//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.7 Page 454
//Title: Orsat analysis of flue gas from boiler house chimney

//======================================================
package Ex7_7

//======================================================
model Ex7_7_a 
/* % excess air */

//======================================================
//Parameter Section
parameter Real n(unit = "kmol") = 100 "Dry flue gases" ;

//======================================================
//Variable Section
Real O2_acc(unit = "kmol") "O2 accounted" ;
Real O2_avail(unit = "kmol") "O2 available" ;
Real O2_exc(unit = "kmol") "O2 excess" ;
Real O2_unacc(unit = "kmol") "O2 unaccounted" ;
Real H2_bur(unit = "kmol") "H2 burnt" ;
Real theo_O2(unit = "kmol") "Theoretical O2 requirement" ;
Real excess "Percent excess O2" ;

//======================================================
//Equation Section
equation
O2_acc = 11.4+4.2 ;
O2_avail = (21/79)*84.4 ;
O2_exc = 4.2 ;
O2_unacc = O2_avail-O2_acc ;
H2_bur = 2*O2_unacc ;
theo_O2 = O2_avail-O2_exc ;
excess = O2_exc*100/theo_O2 ;

end Ex7_7_a ;
//======================================================

//======================================================
model Ex7_7_b 
/* % C:H ratio of fuel */

//======================================================
//Variable Section
Real m1(unit = "kg") "Mass of H2 burnt" ;
Real m2(unit = "kg") "Mass of C burnt" ;
Real ratio "C:H ratio" ;

//======================================================
//Equation Section
equation
m1 = 13.67*2 ;
m2 = 11.4*12 ;
ratio = m2/m1 ;

end Ex7_7_b ;
//======================================================

end Ex7_7;
//======================================================