//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.9 Page 465
//Title: Stoker fired water tube boiler

//======================================================
model Ex7_9

//======================================================
//Parameter Section
parameter Real F(unit = "kmol") = 100 "Moles of dry flue gas as basis" ;

//======================================================
//Variable Section
Real N2(unit = "kmol") "N2 in flue gas" ;
Real O2(unit = "kmol") "O2 supply from air" ;
Real O2_acc(unit = "kmol") "O2 accounted for H1 burning" ;
Real O2_unacc(unit = "kmol") "O2 unaccounted" ;
Real H2(unit = "kmol") "H2 burnt" ;
Real H2O(unit = "kmol") "Water produced" ;
Real C(unit = "kg/hr") "C retained in cinder" ;
Real C1 "C unburnt ratio" ;
Real C2(unit = "kg") "C in flue gas" ;
Real H(unit = "kg") "H2 in flue gas" ;
Real burnt(unit = "kg") "Burnt combustibles" ;
Real unburnt(unit = "kg") "unburnt combustibles as C" ;
Real O2_exc(unit = "kmol") "Excess O2" ;
Real theo_O2(unit = "kmol") "Theoretical O2" ;
Real excess "Excess air" ;
Real H7(unit = "kJ") "Heat lost in flue gas" ;
Real H71(unit = "kJ") "Heat lost in flue gas" ;
Real Q7(unit = "kJ/hr") "Fuel firing rate" ;
Real Q1(unit = "kJ/hr") "Heat of fuel burning" ;
Real Hstgen(unit = "kW") "Steam generation" ;
Real E "Overall thermal efficiency" ;

//======================================================
//Equation Section
equation
N2 = F-12.8-6.5 ;
O2 = (21/79)*N2 ;
O2_acc = 12.8+6.5 ;
O2_unacc = O2-O2_acc ;
H2 = 2.15*2 ;
H2O = 4.3 ;
//New basis: Coal firing rate = 3.9 ton/hr
C = 2.7*3.9*1000/100 ;
C1 = 2.7/(F-12.68-7.91-2.7) ;
C2 = 12.8*12 ;
H = 4.3*2 ;
burnt = C2+H ;
unburnt = C1*burnt/12 ;
O2_exc = 6.5-unburnt ;
theo_O2 = 12.8+unburnt+O2_unacc ;
excess = O2_exc/theo_O2*100 ;
//Using mean heat capacity data from Table 7.21
H7 = 1.0875*100*30.31*(423.15-298.15) ;
H71 = 3633.654*(423.15-298.15) ;
Q7 = H71*3900/burnt*0.7671 ;
Q1 = 3.9*1000*26170 ;
//Performing heat balance
Hstgen = 23546.07 ;
E = Hstgen/Q1*3600*100 ;

end Ex7_9;
//======================================================