//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-1: Dimensions and Units
//Example: 1.1 Page 12
//Title: Unit Conversions
//============================================
model Ex1_1

//============================================
//Parameter Section
parameter Real d(unit = "mm") = 80 "Nominal diameter" ;
parameter Real v(unit = "Imperial gallons/min") = 75 "Volumetric flow rate" ;
parameter Real p(unit = "kg/dm^3") = 0.8 "Density of kerosene" ;

//============================================ 
//Variable Section
Real m(unit = "kg/s") "Mass flow rate" ;
Real q(unit = "dm^3/s") "Volumetric flow rate of kerosene" ;

//============================================ 
//Equation section
equation
q = v/0.219969/60 ;
m = q*p ;
//Note:Use of conversion factors from Table 1.3, pg 9
    
end Ex1_1;
//============================================