//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.15 Page 25
//Title: TOC and ThOD
//===================================================
model Ex2_15

//===============================================
//Paramater Section
parameter Real m(unit = "mg") = 600 "Mass of Glycerin" ;
parameter Real v(unit = "L") = 1 "Volume of solution" ;

//===============================================
//Variable Section
Real c(unit = "mg/L") "Concentration of Glycerin" ;
Real TOC(unit = "mg/L") "Total Carbon Content in solution" ;
Real ThOD(unit = "mg/L") "Theoretical Oxygen Demand for complete combustion of Glycerin" ;

//===============================================
//Equation Section
equation
c = m/v ;
TOC = c*3*12/92 ;
ThOD = c*3.5*32/92 ;
//Molar mass of glycerin is 92
//3.5 mol of oxygen is required for combustion of 1 mol of glycerin" ;

end Ex2_15;
//===============================================




