//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.16 Page 25
//Title: Temporary hardness
//===================================================
model Ex2_16

//Parameter section
parameter Real h(unit = "mg/L") = 500 "Equivalent hardness in terms of CaCO3" ; 
parameter Real c = 60 "Percentage of temporary hardness due to Ca(HCO3)2" ;
parameter Real m = 40 "Percentage of temporary hardness due to Mg(HCO3)2" ;
parameter Real E1 = 50 "Equivalent mass of CaCO3" ;
parameter Real E2 = 81 "Equivalent mass of Ca(HCO3)2" ;
parameter Real E3 = 73.15 "Equivalent mass of Mg(HCO3)" ;

//====================================================
//Variable section
Real C1(unit = "mg/L" ) "Actual concentration of Ca(HCO3)2 in the sample water" ;
Real C2(unit = "mg/L" ) "Actual concentration of Mg(HCO3)2 in the sample water" ;

//====================================================
//Equation Section
equation
C1 = E2/E1*h*c/100 ;
C2 = E3/E1*h*m/100 ;

end Ex2_16;
//===================================================