//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.18 Page 26
//Title: Molarity, Molality and Normality
//===================================================
model Ex2_18

//===============================================
//Parameter Section
parameter Real mp = 20 "Mass percent of NaCl in the solution" ;
parameter Real p(unit = "kg/L" ) = 1.127 "Density of solution" ;

//===============================================
//Variable Section
Real M(unit = "mol/L") "Molarity of the solution" ;
Real N(unit = "mol/L") "Normality of the solution" ;
Real m(unit = "mol/kg") "Molality of the solution" ;
Real V(unit = "L" ) "Volume of the solution" ;
Real n(unit = "mol" ) "Moles of NaCl in solution" ;

//===============================================
//Equation section
equation
V = 100/p ;
n = mp/58.5*1000 ;
M = n/V ;
N = M                    "Valence of NaCl is 1" ;
m = n/(100-mp) ;

//Note:Basis-100 kg of solution
//58.5 Molecular Weight of NaCl
//n is multiplied with 1000 to convert kmole to mole

end Ex2_18;
//===============================================