//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.20 Page 27
//Title: Concentration of CO2
//===============================================
model Ex2_20

//===============================================
//Parameter section
parameter Real M(unit = "kg") = 100 "Total mass of MEA solution (basis)" ;
parameter Real m(unit = "kg") = 20 "Mass of MEA in solution" ;
parameter Real d(unit = "kg/L") = 1 "Density of MEA solution" ;
parameter Real c = 0.206 "kmoles of CO2 per kmole of MEA" ;

//===============================================
//Variable section
Real n1(unit = "kmol") "kmole of MEA" ;
Real n2(unit = "kmol") "kmole of water" ;
Real n3(unit = "kmol") "kmole of CO2" ;
Real m1(unit = "kg") "Mass of CO2" ;
Real m2(unit = "kg") "Mass of water" ;
Real mp "Mass percent of CO2" ;
Real mop "Mole percent of CO2" ;

//===============================================
//Equation section
equation
n1 = m/61 ;
n3 = c*n1 ;
m1 = n3*44 ;
m2 = M-(m1+m) ;
n2 = m2/18 ;
mp = m1/M*100 ;
mop = n3/(n1+n2+n3)*100 ;

//Molar mass of MEA 61 kg/kmol
//MOlar mass of CO2 44 kg/kmol
//Molar mass of water 18 kg/kmol

end Ex2_20;
//===============================================