//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.5 Page 19
//Title: Equivalent mass
//===================================================
package Ex2_5

//===================================================
model Ex2_5_a
/* PO4 radical */

//===================================================
//Parameter Section
parameter Real V1 = 3 "Valence of PO4 radical" ;

//===================================================
//Variable Section
Real M1(unit = "kg/kmol") "Molar mass of PO4" ;
Real E1 "Equivalent mass of PO4 radical" ;

//===================================================
//Equation Section
equation
M1 = 31+4*16 ;
E1 = M1/V1 ;

end Ex2_5_a ;
//===================================================

//===================================================
model Ex2_5_b
/* Na3PO4 */

//===================================================
//Parameter Section
parameter Real V2 = 3 "Valence of Na3PO4" ;

//===================================================
//Variable Section
Real M2(unit = "kg/kmol") "Molar mass of Na3PO4" ;
Real E2  "Equivalent mass of Na3PO4" ;

//===================================================
//Equation Section
equation
M2 = 3*23+95 ;
E2 = M2/V2 ;

end Ex2_5_b ;
//===================================================

end Ex2_5;
//===================================================
