//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.15 Page 76
//Title: Air conditioning plant

//=======================================================
package Ex3_15

//Refer Table 3.8: Data on molar humidity, page 76
 
 //=======================================================
 model Ex3_15_a
 /* Moisture removed */
 
 //=======================================================
 //Parameter Section
 parameter Real Ma(unit = "m3/s") = 5.806 "Mass flow rate of air to the audi" ;
 parameter Real Ta(unit = "K") = 290 "Dry bulb temperature of air flowing into audi" ;
 parameter Real P(unit = "kPa") = 101.3 "Total pressure" ;
  
  //=======================================================
  //Variable Section
  Real Va1(unit = "m3/kmol") "Specific volume of moist air at Ta and P" ;
  Real na1(unit = "mol/s") "Molar flow rate of air into audi" ;
  Real nw1(unit = "mol/s") "Moles of moisture in air entering audi" ;
  Real na2(unit = "mol/s") "Moles of dry air" ;
  Real nw2(unit = "mol/s") "Moisture in air entering air-conditioning plant" ;
  Real Mr(unit = "kg/hr") "Moisture removed in air conditioning plant" ;
  
  //=======================================================
  //Equation Section
  equation
  Va1 = 8.314*Ta/P ;
  na1 = Ma/Va1*1000 ;
  nw1 = na1*0.0163/(1+0.0163) ;
  na2 = na1-nw1 ;
  nw2 = na2*0.0225 ;
  Mr = (nw2-nw1)*18*3600/1000 ;
  
  //Taking the flow rate of dry air to be unchanged
  //Mr is multiplied with 18 to convert moles to gram
  //Mr is multiplied with 3600 to convert per second to per hour
  //Mr is divided with 1000 to convert gram to kilogram 
  
 end Ex3_15_a ;
 //=======================================================
 
 //=======================================================
 model Ex3_15_b
 /* Moisture added in audi */
 
 //=======================================================
 extends Ex3_15_a ;
 
 //=======================================================
 //Variable Section
 Real mm2(unit = "mol/s") "Moisture in air leaving audi" ;
 Real Madd(unit = "kg/hr") "Moisture added in audi" ;
 
 //=======================================================
 //Equation Section
 equation 
 mm2 = na2*0.0181 ;
 Madd = (mm2-nw1)*18/1000*3600 ;
 
 //Note:Ma is multiplied with 18 to convert moles to gram
 //Madd is multiplied with 3600 to convert per second to per hour
 //Madd is divided with 1000 to convert gram to kilogram 
 
 end Ex3_15_b ;
 //=======================================================
 
 //=======================================================
 model Ex3_15_c
 /* Recycle ratio */
 
 extends Ex3_15_a ;
 //=======================================================
 
 //Parameter Section
 parameter Real Mf(unit = "m3/s") = 1.25 "Mass flow rate fresh ambient air" ;
 parameter Real Tf(unit = "K") = 308 "Temperature of fresh air" ;
 
 //=======================================================
 //Variable Section
 Real Vm2(unit = "m3/kmol") "Specific volume of fresh air" ;
 Real na3(unit = "mol/s") "Molar flow rate of fresh air" ;
 Real nm3(unit = "mol/s") "Moisture in fresh air" ;
 Real na4(unit = "mol/s") "Dry air flow in fresh air" ;
 Real nm4(unit = "mol/s") "Moisture in recycle stream" ;
 Real Mwet(unit = "mol/s") "Flow rate of wet recycled stream" ;
 Real R "Recycle ratio in kmol recycle stream/kmol fresh feed" ;
 //=======================================================
 //Equation Section
 equation
 Vm2 = 8.314*Tf/P ;
 na3 = (Mf/Vm2)*1000 ;
 nm3 = (0.0405/1.0405)*na3 ; 
 na4 = na3 - nm3 ;
 nm4 = nw2 - nm3 ;
 Mwet = (na2-na4)+nm4 ;
 R = Mwet/na3 ;
 
 //Note:R Ideal gas constant in (kPa m3)/(kmol/K)
 //na3 is multiplied with 1000 to convert kmole to mole
 
 end Ex3_15_c ;
 //=======================================================
  
end Ex3_15;
//=======================================================
