//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.3 Page 61
//Title: Recovery of tannin
//=======================================================
model Ex3_3

//=======================================================
//Parameter Section
parameter Real sample(unit = "kg") = 100 "Basis for mass of babul bark as feed" ;
parameter Real m1(unit = "kg") = 5.8 "Mass of moisture in feed" ;
parameter Real m2(unit = "kg") = 12.6 "Mass of tannin in feed" ;
parameter Real m3(unit = "kg") = 8.3 "Mass of non-tannins in feed" ;
parameter Real R1 = 0.92 "percentage of tannin in residue" ;
parameter Real R2 = 0.65 "Percentage of non-tannins in residue" ;

//=======================================================
//Variable Section
Real m4(unit = "kg") "Mass of lignin in feed" ;
Real R3 "Lignin content in residue" ;
Real x(unit = "kg") "Final mass of dry residue" ;
Real T1(unit = "kg") "Mass of tannin in residue" ;
Real T2 "tannin recovered" ;

//======================================================= 
//Equation Section
equation
m4 = sample-(m1+m2+m3) ;
R3 = 100-(R1+R2) ; //kg of lignin/100 kg of dry residue
R3/100*x = m4 ;
T1 = x*R1/100 ;
T2 = (m2-T1)/m2*100 ;

//Analysis at dry basis
//Assuming lignin to be inert

end Ex3_3;
//=======================================================