//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.10 Page 128
//Title: Formox process

//=======================================================
model Ex4_10

//=======================================================
//Parameter Section
parameter Real feed(unit = "kg/hr") = 4000 "Basis for methanol feed rate" ;
parameter Real conc = 8.4 "Volume percent of methanol in gaseous feed" ;
parameter Real H = 0.011 "Moisture content of ambient air in kg H2O/kg dry air" ;
parameter Real Conv = 99 "Conversion of methanol "; 
parameter Real yield = 90 "Percent yield of HCHO" ;
parameter Real C = 37 "Mass percent of HCHO at bottom of absorber" ;

//=======================================================
//Variable Section
Real MeOH(unit = "kmol/hr") "Molar feed rate of methanol" ;
Real F(unit = "kmol/hr") "Feed flow rate" ;
Real air(unit = "kmol/hr") "Flow rate of ambient wet air" ;
Real h "Moisture in air in kmol H2O/kmol dry air" ;
Real D(unit = "kmol/hr") "Dry air flow rate" ;
Real O2(unit = "kmol/hr") "O2 supply rate in feed" ; 
Real N2(unit = "kmol/hr") "N2 supply rate in feed" ;
Real H2O(unit = "kmol/hr") "H2O entering with air" ;
Real comp[4,2] "Table 4.8, pg 130" ;
Real T(unit = "kmol/hr") "Total feed rate" ;
Real M_react(unit = "kmol/hr") "Total methanol reacted" ;
Real M_unreact(unit = "kmol/hr") "Unreacted methanol" ;
Real MeOH1(unit = "kmol/hr") "Methanol reacted in reaction (i)" ;
Real HCHO(unit = "kmol/hr") "HCHO formed" ;
Real O2_i(unit = "kmol/hr") "O2 consumed in rnx (i)" ;
Real H2O_i(unit = "kmol/hr") "H2O produced in rnx (i)" ;
Real meth(unit = "kmol/hr") "Methanol consumed from rnx (ii) to (v)" ;
Real MeOH2(unit = "kmol/hr") "MeOH consumed in rnx (ii)" ;
Real O2_ii(unit = "kmol/hr") "O2 consumed in rnx (ii)" ;
Real CO2(unit = "kmol/hr") "CO2 produced in rnx (ii)" ;
Real H2O_ii(unit = "kmol/hr") "H2O produced in rnx (ii)" ;
Real MeOH3(unit = "kmol/hr") "MeOH consumed in rnx (iii)" ;
Real CO(unit = "kmol/hr") "CO produced in rnx (iii)" ;
Real H2(unit = "kmol/hr") "H2 produced in rnx (iii)" ;
Real MeOH4(unit = "kmol/hr") "MeOH consumed in rnx (iv)" ;
Real CH4(unit = "kmol/hr") "CH4 produced in rnx (iv)" ;
Real O2_iv(unit = "kmol/hr") "O2 produced in rnx (iv)" ;
Real MeOH5(unit = "kmol/hr") "MeOH consumed in rnx (v)" ;
Real DME(unit = "kmol/hr") "DME produced in rnx (v)" ;
Real H2O_v(unit = "kmol/hr") "H2O produced in rnx (v)" ;
Real O2_exit(unit = "kmol/hr") "O2 in exit stream" ;
Real H2O_exit(unit = "kmol/hr") "Water in exit stream" ;
Real Formald(unit = "kg/hr") "HCHO in bottom solution" ;
Real soln(unit = "kg/hr") "Solution withdrawl rate" ;
Real M_bot(unit = "kg/hr") "Methanol in bottom soln" ;
Real water(unit = "kg/hr") "Water in bottom soln" ;
Real Moisture(unit = "kg/hr") "Moisture enetring absorber" ;
Real m(unit = "kg/hr") "Fresh water added at the top of the absorber" ;

//=======================================================
//Equation Section
equation
MeOH = feed/32 ;
F = MeOH/(conc/100) ;
air = F-MeOH ;
h = H*29/18 ;
D = air/(1+h) ;
O2 = D*0.21 ;
N2 = D-O2 ;
H2O = air-D ;
comp[1,1] = MeOH ;
comp[2,1] = O2 ;
comp[3,1] = N2 ;
comp[4,1] = H2O ;
T = MeOH+O2+N2+H2O ;
for i in 1:4 loop
    comp[i,2] = comp[i,1]/T*100 ;
end for ;
M_react = MeOH*Conv/100 ;
M_unreact = MeOH-M_react ;
//Reaction (i)
 MeOH1 = M_react*yield/100 ;
 HCHO = MeOH1 ;
 O2_i = HCHO/2 ;
 H2O_i = HCHO ;
//Reaction (ii)  to (v) 
 meth = M_react*0.1 ;
//Reaction (ii)
 MeOH2 = meth*0.71 ;
 O2_ii = MeOH2*1.5 ;
 CO2 = MeOH2 ;
 H2O_ii = MeOH2*2 ;
//Reaction (iii)
 MeOH3 = meth*0.08 ;
 CO = MeOH3 ;
 H2 = MeOH3*2 ;
//Reaction (iv)
 MeOH4 = meth*0.05 ;
 CH4 = MeOH4 ;
 O2_iv = MeOH4/2 ;
//Reaction 9v)
 MeOH5 = meth*0.16 ;
 DME = MeOH5/2 ;
 H2O_v = MeOH5/2 ;
O2_exit = O2-O2_i-O2_ii+O2_iv ;
H2O_exit = H2O+H2O_i+H2O_ii+H2O_v ;
//Material balance across absorber
Formald = HCHO*30 ;
soln = Formald*100/C ;
M_bot = M_unreact*32 ;
water = soln-(Formald+M_bot) ;
Moisture = H2O_exit*18 ;
m = 2649+water-Moisture ;

//Note:Molar mass of methanol 32 kg/kmol
//Mole percent of O2 in air 0.21

end Ex4_10;
//=======================================================