//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.21 Page 159
//Title: Blast furnace

//=======================================================
package Ex4_21

//=======================================================
model Ex4_21_b
/* Mass of ore used */

//=======================================================
//Parameter Section
parameter Real M(unit = "kg") = 1000 "Mass of pig iron as basis" ;
parameter Real M1(unit = "kg") = 1000 "Mass of Coke" ;
parameter Real M2(unit = "kg") = 400 "Mass of Flux" ;

//=======================================================
//Variable Section
Real Fe(unit = "kg") "Fe in pig iron" ;
Real Fe_ore(unit = "kg") "Fe in ore" ;
Real Ore(unit = "kg") "Ore required" ;

//=======================================================
//Equation Section
equation
Fe = 0.95*M1 ;
Fe_ore = (112/160)*0.8 ;
Ore = Fe/Fe_ore ;

end Ex4_21_b ;
//=======================================================

//=======================================================
model Ex4_21_a
/*Mass of slag made */

//=======================================================
//Variable Section
Real m1(unit = "kg") "Si in pig iron" ;
Real m2(unit = "kg") "SiO2 in pig iron" ;
Real m3(unit = "kg") "SiO2 in ore" ;
Real m4(unit = "kg") "SiO2 in coke" ;
Real m5(unit = "kg") "SiO2 in slag" ;
Real m6(unit = "kg") "Al2O3 in ore" ;
Real m7(unit = "kg") "Al2O3 in slag" ;
Real m8(unit = "kg") "CaO in slag" ;
Real slag(unit = "kg") "Total mass of slag" ;

//=======================================================
//Reference Section
extends Ex4_21_b ;

//=======================================================
//Equation Section
equation
m1 = 0.014*M ;
m2 = (60/28)*m1 ;
m3 = Ore*0.12 ;
m4 = M1*0.1 ;
m5 = m3+m4-m2 ;
m6 = Ore*0.08 ;
m7 = m6 ;
m8 = (56/100)*M2 ;
slag = m5+m7+m8 ;

end Ex4_21_a ;
//=======================================================

//=======================================================
model Ex4_21_c
/* Composition of slag */

//=======================================================
//Reference Section
extends Ex4_21_a ;

end Ex4_21_c ;
//=======================================================

//=======================================================
model Ex4_21_d
/* Volume of air */

//=======================================================
//Variable Section
Real C(unit = "kg") "Total Carbon available" ;
Real C1(unit = "kg") "C converted to CO" ;
Real C2(unit = "kg") "C converted to CO2" ;
Real O2(unit = "kg") "O2 required to form CO and CO2" ;
Real O21(unit = "kg") "O2 supplied from SiO2" ;
Real O22(unit = "kg") "O2 supplied from Fe2O3" ;
Real O23(unit = "kg") "O2 supplied from CaCO3" ;
Real T_O2(unit = "kmol") "Total O2 supplied from air" ;
Real air(unit = "kmol") "Air supplied ";
Real V(unit = "m^3") "Volume of air supplied at NTP" ;

//=======================================================
//Referance Section
extends Ex4_21_b ;
extends Ex4_21_a ;

//=======================================================
//Equation Section
equation
C = 0.9*M1+(12/100)*M2-36 ;
C2 = (1/3)*C ;                           //Ratio of CO:CO2 is 2:1
C1 = (2/3)*C ;
O2 = C1*(16/12)+C2*(32/12) ;
O21 = (32/28)*m1 ;
O22 = (48/160)*Ore*0.8 ;
O23 = (32/100)*M2 ;
T_O2 = (O2-(O21+O22+O23))/32 ;
air = T_O2/0.21 ;
V = air*22.414 ;

//Note:Specific Volume of air at NTP is 22.414 m^3/kmol
end Ex4_21_d ;
//=======================================================

end Ex4_21;
