//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.8 Page 124
//Title: Sulphur burner

//=======================================================
package Ex4_8

//=======================================================
model Ex4_8_a
/* Sulphur burnt into SO3 */

//=======================================================
//Parameter Section
parameter Real m(unit = "kmol") = 100 "Basis for moles of SO3 free gas" ;
parameter Real m1(unit = "kmol") = 16.5 "Moles of SO2 in gases from burner" ; 
parameter Real m2(unit = "kmol") = 3 "Moles of O2 in gases from burner" ;
parameter Real m3(unit = "kmol") = 80.5 "Moles of N2 in gases from burner" ;

//=======================================================
//Variable Section
Real m4(unit = "kmol") "Moles of O2 supplied" ;
Real m5(unit = "kmol") "Unaccounted O2 or O2 consumed as eqn. (ii)" ;
Real m6(unit = "kmol") "SO3 produced" ;
Real m7(unit = "kmol") "Total S burnt" ;
Real fraction "Fraction of S burnt to SO3" ;

//=======================================================
//Equation Section
equation
m4 = 21/79*m3 ;
m5 = m4-(m1+m2) ;
m6 = 2/3*m5 ;         //Acc. to eqn. (i)
m7 = m1+m6 ;          //Moles of SO2 = S burnt into SO2 from eqn. (i)
                      //Moles of SO3 produced = S burnt into SO3 from eqn. (ii)
fraction = m6/m7 ;

 end Ex4_8_a ;
//=======================================================

//=======================================================
model Ex4_8_b 
/* Excess air */

//=======================================================
//Variable Section
Real m8(unit = "kmol") "Excess O2" ;
Real Excess  "Perecnt excess air" ;

//=======================================================
//Reference Section
extends Ex4_8_a ;

//=======================================================
//Equation Section
equation
m8 = m4-m7 ;
Excess = m8/m7 *100 ;

end Ex4_8_b ;
//=======================================================

//=======================================================
model Ex4_8_c
/*Volume of dry air */

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 303.15 "Temperature of fresh air" ;
parameter Real P(unit = "kPa") = 100 "Pressure of fresh air" ;
parameter Real charge(unit = "kg/s") = 0.3 "Actual charge to burner" ;

//=======================================================
//Reference Section
extends Ex4_8_a ;

//=======================================================
//Variable Section
Real N(unit = "kmol") "Air supplied to the burner" ;
Real Supply(unit = "kmol/s") "Air supply rate" ;
Real sp_vol(unit = "m^3/kmol") "Specific volume of incoming fresh air" ;
Real Q(unit = "m^3/s") "Volumetric flow rate of fresh air" ;

//=======================================================
//Equation Section
equation
N = m3+m4 ;
Supply = N/(m7*32)*charge ;
sp_vol = 22.414*(T/273.15)*(101.325/P) ;
Q = Supply * sp_vol ;

//Note: 1 kmol of ideal gas occupies 22.414 m^3 volume

end Ex4_8_c ;
//=======================================================

//=======================================================
model Ex4_8_d
/* Volume of burner gas */

//=======================================================
//Reference Section
extends Ex4_8_c ;

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 1073 "Tempertaure of gas leaving burner" ;
parameter Real P1(unit = "kPa") = 101.325 "Pressure of gases leaving burner" ;

//=======================================================
//Variable Section
Real N1(unit = "kmol") "Total gases from burner, for basis of 100 kmol of SO3-free gas" ;
Real N2(unit = "Kmol/s") "Total gas,for 0.3 kg/s sulphur charge" ;
Real sp_vol1(unit = "m^2/kmol") "Specific volume of burner gas" ;
Real Q1(unit = "m^3/s") "Volumetric flow rate of burner gas" ;

//=======================================================
//Equation Section
equation
N1 = m+m6 ;
N2 = N1/(m7*32) * 0.3 ;
sp_vol1 = 22.414*(T1/273.15) ;
Q1 = N2*sp_vol1 ;

//Note: 1 kmol of ideal gas occupies 22.414 m^3 volume

end Ex4_8_d ;
//=======================================================

end Ex4_8;
//=======================================================
