//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.16 Page 238
//Title: Liquefaction of Cl2

//=======================================================
package Ex5_16

//=======================================================
model Ex5_16_a
/* Recycle ratio of Cl2 */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg/s") = 0.116 "Liquefaction capacity" ;
parameter Real p1(unit = "kPa") = 101 "Pressure of saturated gas leaving wash column" ;
parameter Real Ts1(unit = "K") = 239.15 "Saturation temperature at p1" ;
parameter Real p2(unit = "kPa") = 631.3 "Pressure of final saturated product" ;
parameter Real Ts2(unit = "K") = 290.75 "Saturation temperature at p2" ;
parameter Real lambda1(unit = "kJ/kmol") = 20430 "Latent heat of vapourisation using Antoine eqn" ;
parameter Real lambda2(unit = "kJ/kmol") = 17934 "Latent hrat of vapourisation using Watson eqn" ;
parameter Real T3(unit = "K") = 313.15 "Feed temperature" ;

//=======================================================
//Variable Section
Real H1(unit = "kJ/kmol") "Sensible heat of liq. Cl2 at 290.75" ;
Real x "Liquid Cl2 flashed per kg of liquid Cl2 at 631.3 kPa" ;
Real H2(unit = "kJ/kmol") "Sensible heat to be removed from fresh Cl2 feed" ;
Real Q2(unit = "kW") "Heat extracted from fresh feed" ;
Real m1(unit = "kg/s") "Liq Cl2 evaporated" ;
Real R "Recycled liq. Cl21" ;
Real recy_ratio "Recycle ratio in kg liq. Cl2 recycled per kg of feed Cl2 gas" ;

//=======================================================
//Equation Section
equation
H1 = -39.246*(Ts2-Ts1)+1401.223*10^(-3)*(Ts2^2-Ts1^2)/2-6047.226*10^(-6)*(Ts2^3-Ts1^3)/3+8591.4*10^(-9)*(Ts2^4-Ts1^4)/4 ;
H1 = x*lambda1 ;
H2 = 28.5463*(T3-Ts1)+23.8795*10^(-3)*(T3^2-Ts1^2)/2-21.3631*10^(-6)*(T3^3-Ts1^3)/3+6.4726*10^(-9)*(T3^4-Ts1^4)/4 ;
Q2 = m*H2/70.906 ;
m1 = Q2/288.13 ;
R = m1/(1-0.185) ;
recy_ratio = R/m ;

//Note: Base temperature is taken as 239.15

end Ex5_16_a ;
//=======================================================

//=======================================================
model Ex5_16_b
/* Cooling water requirement */

//=======================================================
//Parameter Section
parameter Real p2(unit = "kPa") = 326.3 "Pressure of gas from I stage of compressor" ;
parameter Real p1(unit = "kPa") = 101 "Pressure of gas enetring I stage" ;
parameter Real gamma = 1.355 "Ratio of heat capacities at const. pressure to cont. volume" ;
parameter Real T1(unit = "K") = 239.15 "Temperature at pressure  p1" ;
parameter Real T5(unit = "K") = 313.15 "Temperature after intercooling" ;
parameter Real p4(unit = "kPa") = 661.3 "Pressure of gas from II stage of compressor" ;
parameter Real p3(unit = "kPa") = 316.3 "Pressure of gas enetring II stage" ;

//=======================================================
//Variable Section
Real T4(unit = "K") "Temperature of gas leaving I stage" ;
Real Q3(unit = "kW") "Enthalpy removed in intercooler" ;
Real m2(unit = "kg/s") "Cooling water flow rate in intercooler" ;
Real T6(unit = "K") "Temperature of gas leaving II stage" ;
Real Q4(unit = "kW") "Enthalpy removed in aftercooler" ;
Real m3(unit = "kg/s") "Cooling water flow rate in aftercooler" ;
Real T(unit = "kg/s") "Total cooling water flow rate" ;

//=======================================================
//Equation Section
equation
//First-stage compression
(T4/T1) = (p2/p1)^((gamma-1)/gamma) ;                                  //Adiabatic compression
Q3 = 0.1333/70.906*(28.5463*(T4-T5)+23.8795*10^(-3)*(T4^2-T5^2)/2-21.3631*10^(-6)*(T4^3-T5^3)/3+6.4726*10^(-9)*(T4^4-T5^4)/4) ;
m2 = Q3/(8*4.1868) ;

//Second-stage compression
(T6/T5) = (p4/p3)^((gamma-1)/gamma) ;
Q4 = 0.1333/70.906*(28.5463*(T6-T5)+23.8795*10^(-3)*(T6^2-T5^2)/2-21.3631*10^(-6)*(T6^3-T5^3)/3+6.4726*10^(-9)*(T6^4-T5^4)/4) ;
m3 = Q4/(8*4.1868) ;
T = m2+m3 ;

end Ex5_16_b ;
//=======================================================

//=======================================================
model Ex5_16_c
/* Refrigeration load of chiller */

//=======================================================
//Parameter Section
parameter Real T2(unit = "K") = 290.75 "Saturation temperature at 631.3 kPa" ;
parameter Real T5(unit = "K") = 313.15 "Temperature after intercooling" ;

//=======================================================
//Variable Section
Real Q5(unit = "kW") "Heat removal rate" ;

//=======================================================
//Equation Section
equation
Q5 = 0.1333/70.906*(28.5463*(T5-T2)+23.8795*10^(-3)*(T5^2-T2^2)/2-21.3631*10^(-6)*(T5^3-T2^3)/3+6.4726*10^(-9)*(T5^4-T2^4)/4) + 0.1333*17934/70.906 ;

end Ex5_16_c ;
//=======================================================

end Ex5_16;
//=======================================================
