//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.2 Page 197
//Title: Heating of CH4

//=======================================================
model Ex5_2

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 303.15 "Initial temperature" ;
parameter Real T2(unit = "K") = 523.15 "Final temperature";

//=======================================================
//variable Section
Real H(unit = "kJ") "Heat added per kmole of CH4" ;

//=======================================================
//Equation Section
equation
H = 19.2494*(T2-T1)+52.1135*10^(-3)*(T2^2-T1^2)/2+11.973*10^(-6)*(T2^3-T1^3)/3-11.3173*10^(-9)*(T2^4-T1^4)/4;
//Reference 5
//Note: Using Eq. 5.17

end Ex5_2;
//=======================================================