//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.20 Page 247
//Title: Sulphate burner

//=======================================================
model Ex5_20

//=======================================================
//Parameter Section
parameter Real m(unit = "kg/hr") = 200 "Mass of S burnt" ;
parameter Real T1(unit = "K") = 1144.15 "Temperature of gas entering boiler" ;
parameter Real T2(unit = "K") = 463.15 "Temperature of gas leaving boiler" ;

//=======================================================
//Variable Section
Real n(unit = "kmol/hr") "Molar feed rate S" ;
Real Theo_O2(unit = "kmol/hr") "Theoretical O2 demand" ;
Real Act_O2(unit = "kmol/hr") "Actual O2 supplied" ;
Real air(unit = "kmol/hr") "Air supplied to burner" ;
Real N2(unit = "kmol/hr") "N2 entering burner" ;
Real E(unit = "kJ/hr") "Enthalpy removed" ;
Real H(unit = "kJ/hr") "Enthalpy to be supplied for steam generation" ;
Real qm(unit = "kg/hr") "Mass of Steam generated" ;

//=======================================================
//Equation Section
equation
n = m/32 ;
Theo_O2 = n ;
Act_O2 = Theo_O2*1.1 ;
air = Act_O2/0.21 ;
N2 = air-Act_O2 ;
//Gas effluent from burner contains SO2,O2 and N2
E = 788852.2 ;
H = 15*4.1868+1945.2 ;
qm = E/H*0.9 ;

//Note: Efficiency of steam production is 90% 

end Ex5_20;
//=======================================================