//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.32 Page 269
//Title: Standard heat of reaction

//=======================================================
model Ex5_32

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Basis of 2% ammonia solution" ; 

//=======================================================
//Variable Section
Real Hf(unit = "kJ/mol") "Heat of reaction" ;
Real n1(unit = "kmol") "NH3 present in solution" ;
Real H(unit = "kJ/(100 kg soln)") "Heat of dissolution" ; 

//=======================================================
//Equation Section
equation
Hf = -361.2-(-45.94-285.83) ;
n1 = 2/17.0305 ;
H = -Hf*n1*1000 ;

//Note: Ref. Appendix V.1
end Ex5_32;
//=======================================================