//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.34 Page 272
//Title: Acetic acid esterification

//=======================================================
package Ex5_34

//=======================================================
model Ex5_34_a
/* Heat of reaction using heat capacities at mean temperature */

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 373.15 "Temperature at which heat of reaction to be found" ;

//=======================================================
//Variable Section
Real Hr0(unit = "kJ/mol") "Heat of reaction using heat capacities at mean temperature" ;
Real HrT(unit = "kJ/mol") "Heat of reaction using heat capacities at mean temperature" ;

//=======================================================
//Equation Section
equation
Hr0 = -480-285.83+277.2+484.2 ;
HrT = Hr0+(146.89+75.76-119.55-129.7)*(T1-298.15)/1000 ;

//Note: Cp is divided by 1000 to convert per kmole to per mole 
//Ref. Table 5.24, pg 272

end Ex5_34_a ;
//=======================================================

//=======================================================
model Ex5_34_b
/* Heat of reaction using heat capacity equation */

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 373.15 "Temperature at which heat of reaction to be found" ;

//=======================================================
//Variable Section
Real delta_a "Parameter of heat capacity equation" ;
Real delta_b "Parameter of heat capacity equation" ;
Real delta_c "Parameter of heat capacity equation" ;
Real delta_d "Parameter of heat capacity equation" ;
Real Hr0(unit = "kJ/kmol") "Standard heat of reaction" ;
Real HrT(unit = "kJ/mol") "Heat of reaction" ;

//=======================================================
//Equation Section
equation
delta_a = 4.2905+50.845-100.92-155.48 ;
delta_b = (934.378+213.08-(-111.83-326.595))*10^(-3) ;
delta_c = (-2640-631.398-498.54-744.199)*10^(-6) ;
delta_d = (3342.58+648.746)*10^(-9) ;
Hr0 = -4.43*1000-(delta_a*298.15+delta_b*(298.15)^2/2+delta_c*(298.15)^3/3+delta_d*(298.15)^4/4) ;
HrT = (Hr0-201.2645*T+792.949*10^(-3)*T^2-1504.712*10^(-6)*T^3+997.832*10^(-9)*T^4)/1000 ;

end Ex5_34_b ;
//=======================================================

end Ex5_34;
//=======================================================
