//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.36 Page 275
//Title: Enthalpy balance of a reactor 

//=======================================================
model Ex5_36

//=======================================================
//Parameter Section
parameter Real n(unit = "kmol") = 100 "Basis of outgoing gas mixture" ;
parameter Real H1 = 0.015 "Moisture in ingoing air in kg H2O/kg dry air" ;

//=======================================================
//Variable Section
Real H2O_in(unit = "kmol") "Moisture in inlet gas" ;
Real H2O(unit = "kmol") "Total water in reactor effluent" ;
Real Hr(unit = "kJ/kmol") "Net heat of reaction per kmol of C2H5OH" ;

//=======================================================
//Equation Section
equation
H2O_in = H1*n/18 ;
H2O = H2O_in+40.2 ;
//From Table 5.29 and 5.30 
Hr = (-27002658-(-26853359))/(135.99-89.09) ;

//Ref. Ex4_4
end Ex5_36;
//=======================================================