//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.37 Page 276
//Title: Calculation of circulation rate 

//=======================================================
model Ex5_37

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 383.15 "Inlet temp. of air ingoing into heat exchanger" ;
parameter Real T2(unit = "K") = 613.15 "Inlet temp. of air outgoing from heat exchanger" ;
parameter Real T0(unit = "K") = 308.15 "Air entering heat exchanger" ;
//=======================================================
//Variable Section
Real Hr1(unit = "kJ/mol") "Standard heat of reaction for rnx 1 per mole of CH3OH" ;
Real Hr2(unit = "kJ/mol") "Standard heat of reaction for rnx 2 per mole of CH3OH" ;
Real Hr3(unit = "kJ/mol") "Standard heat of reaction for rnx 3 per mole of CH3OH" ;
Real Hr4(unit = "kJ/mol") "Standard heat of reaction for rnx 4 per mole of CH3OH" ;
Real Hr5(unit = "kJ/mol") "Standard heat of reaction for rnx 5 per mole of CH3OH" ;
Real Hr0(unit = "kJ/hr") "Total heat of reaction per mole of CH3OH" ;
Real Lambda(unit = "kJ/kmol") "Latent heat of vapourisation of Methanol" ;
Real Q1(unit = "kJ/hr") "Heat duty of evaporator" ;
Real Q3(unit = "kJ/hr") "Enthalpy of reactor exit gas stream" ;
Real C(unit = "kg/hr") "Recirculation rate" ;

//=======================================================
//Equation Section
equation
Hr1 = -241.82-108.6-(-200.94) ;
Hr2 = -393.51-241.82-(-200.94) ;
Hr3 = -110.53-(-200.94) ;
Hr4 = -74.52-(-200.94) ;
Hr5 = -184.0-241.82-(-2*200.94) ;
Hr0 = 111.375*(Hr1*1000)+8.786*(Hr2*1000)+0.99*(Hr3*1000)+0.61*(Hr4*1000)+1.98*(Hr5*1000) ;
Lambda = 35210*((512.5-351.45)/(512.5-337.7 ))^(0.38) ;
Q1 = 462513+125*Lambda ;
Q3 = 17131551 ;
C = Q3/296.2 ;

//Note: Assuming constant molar heat capacity
//Ref. Table 5.31

end Ex5_37;
//=======================================================