//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.41 Page 294
//Title: Dehydrogenation of EB 

//=======================================================
model Ex5_41

//=======================================================
//Parameter Section
parameter Real n1(unit = "kmol") = 1 "Moles of EB entering the reactor" ;
parameter Real T0(unit = "K") = 811.15 "Tempeature of vapours entering reactor " ;
parameter Real n2(unit = "kmol") = 15 "Moles of steam entering the reactor" ;
parameter Real T2(unit = "K") = 978.15 "Tempeature of vapours entering reactor " ;

//=======================================================
//Variable Section
Real T1(unit = "K",start = 50) "Temperature of reactant gas stream" ;
Real H1(unit = "kJ") "Enthalpy of reactants" ;
Real n3(unit = "kmol") "EB reacted" ;
Real n4(unit = "kmol") "Styrene in product stream" ;
Real n5(unit = "kmol") "C6H6  produced by rnx B" ;
Real n6(unit = "kmol") "Ethylene produced by rnx B" ;
Real n7(unit = "kmol") "C produced by rnx C" ;
Real n8(unit = "kmol") "Toluene produced by rnx D " ;
Real n9(unit = "kmol") "EB reacted by rnx A" ;
Real n10(unit = "kmol") "H2 produced" ;
Real Hr1(unit = "kJ/mol") "Heat of reaction of rnx A" ;
Real Hr2(unit = "kJ/mol") "Heat of reaction of rnx B" ;
Real Hr3(unit = "kJ/mol") "Heat of reaction of rnx C" ;
Real Hr4(unit = "kJ/mol") "Heat of reaction of rnx D" ;
Real Hr(unit = "kJ/mol") "Total heat of reaction" ;
Real H2(unit = "kJ") "Enthalpy of products" ;
Real T3(unit = "K") "Temperature of product gas stream" ;

//=======================================================
//Equation Section
equation
-36.72*(T1-T0)+671.12*10^(-3)*(T1^2-T0^2)/2-422.02*10^(-6)*(T1^3-T0^3)/3+101.15*10^(-9)*(T1^4-T0^4)/4 = 487.38*(T2-T1)+1.19*10^(-3)*(T2^2-T1^2)/2+198.16*10^(-6)*(T2^3-T1^3)/3-68.21*10^(-9)*(T2^4-T1^4)/4 ;
//H1 = intergrate Cmp1 dT over 298.15 and T1
H1 = 493405 ;
n3 = n1*0.35 ;                                          //35%  conversion
n4 = n3*0.9 ;                                           //Yield of styrene 90%
n5 = n3*0.03 ;                                          //Yield of C6H6 3%
n6 = 0.0105 ;
n7 = n3*0.01 ;
n8 = n3*0.06 ;                                          //Yield of toluene 6%
n9 = 0.315+0.021 ;
n10 = 0.315+0.021+0.0035*5-0.021*2 ;
Hr1 = 147.36-29.92 ;
Hr2 = 82.93+52.5-29.92 ;
Hr3 = -29.92 ;
Hr4 = 50.17-74.52-147.36 ;
Hr = 1000*(Hr1*(0.315+0.021)+Hr2*0.0105+Hr3*0.0035+Hr4*0.021) ;
H2 = H1-Hr ;
T3 = 798.79 ;
 
//Heat of reactions at 298.15
//Note: Ref. Table 5.54
//Toluene produced by rnx D = CH4 produced = styrene reacted by rnx D = EB reacted by rnx A

end Ex5_41;
//=======================================================