//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.43 Page 297
//Title: Heat of crystallisation of Na2SO4.10H2O

//=======================================================
model Ex5_43

//=======================================================
//Parameter Section
parameter Real Hf1(unit = "kJ/mol") = -285.82 "Heat of formation of water" ;
parameter Real Hf2(unit = "kJ/mol") = -1387.08 "Heat of formation of Na2SO4" ;
parameter Real Hf3(unit = "kJ/mol") = -4327.26 "Heat of formation of Na2SO4.10H2O" ;

//=======================================================
//Variable Section
Real Hc(unit = "kJ/mol") "Heat of crystallisation" ;

//=======================================================
//Equation Section
equation
Hc = Hf3-(Hf2+10*Hf1) ;

//Note: Ref. Appendix V.1
end Ex5_43;
//=======================================================