//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.49 Page 302
//Title: Integral heat of solution

//=======================================================
model Ex5_49

//=======================================================
//Parameter Solution
parameter Real H(unit = "kJ/kmol") = 896 "Heat of mixing" ;
parameter Real n(unit = "kmol") = 1 "Moles of solution" ;
parameter Real n1(unit = "kmol") = 0.473 "Moles of C6H6 in solution" ;
parameter Real n2(unit = "kmol") = 0.527 "Moles of n-amyl alcohol in solution" ;

//=======================================================
//Variable section
Real m1(unit = "kg") "Mass of C6H6 in solution" ;
Real m2(unit = "kg") "Mass of n-amyl alcohol in solution" ;
Real H1(unit = "kJ/kg") "Integral heat of soln. of n-amyl alcohol" ;
Real H2(unit = "kJ/kg") "Integral heat of soln. of C6H6" ;

//=======================================================
//Equation Section
equation
m1 = n1*78 ;
m2 = n2*88 ;
H1 = H/m2 ;
H2 = H/m1 ;

end Ex5_49;
//=======================================================