//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.52 Page 306
//Title: Heat removal from mixed acid

//=======================================================
model Ex5_52

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 1000 "Mass of mixed acid" ;

//=======================================================
//Variable Section
Real A1 "Total acid content of spent acid" ;
Real A2 "HNO3 content of anhydrous mixture" ;
Real H1(unit = "kJ/kg") "Enthalpy of spent acid" ;
Real A3 "Total acid content of 90% HNO3" ;
Real A4 "HNO3 content of anhydrous acid" ;
Real H2(unit = "kJ/kg") "Enthalpy of 90% HNO3" ;
Real A5 "Total acid content of 98% H2SO4" ;
Real A6 "HNO3 content of anhydrous acid" ;
Real H3(unit = "kJ/kg") "Enthalpy of 98% H2SO4" ;
Real A7 "Total acid content of mixed acid" ;
Real A8 "HNO3 content of anhydrous acid" ;
Real H4(unit = "kJ/kg") "Enthalpy of final acid" ;
Real H(unit = "kJ") "Heat of mixing" ;

//=======================================================
//Equation Section
equation
//Spent acid at 308.15 K
A1 = 11.3+44.4 ;
A2 = (11.3/A1)*100 ;
H1 = -296.7+2.45*(308.15-273.15) ;     //H=-296.7 kJ/kg, C11=2.45 kJ/kg K, Ref. Fig. 5.21 and Fig. 5.20
//90% HNO3 solution
A3 = 90 ;
A4 = 100 ;
H2 = -87.8+2.2*(308.15-273.15) ;       //H=-87.8 kJ/kg, C12=2.2 kJ/kg K, Ref. Fig. 5.21 and Fig. 5.20
//Aqueous 98% H2SO4
A5 = 98 ;
A6 = 0 ;
H3 = -35.5+1.45*(308.15-273.15) ;       //H=-35.5 kJ/kg, C13=1.45 kJ/kg K, Ref. Fig. 5.21 and Fig. 5.20
//Final mixed acid
A7 =  92;
A8 = (32/92)*100 ;
H4 = -148.9+1.8*(308.15-273.15) ;       //H=-148.9 kJ/kg, C14=1.8 kJ/kg K, Ref. Fig. 5.21 and Fig. 5.20
H =1000*(H4)-(76.3*H1+345.9*H2+577.7*H3) ;

end Ex5_52;
//=======================================================