//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.6 Page 207
//Title: Heat added to Chlorinated diphenyl 

//=======================================================
model Ex5_6

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 313.15 "Initial temperature" ;
parameter Real T2(unit = "K") = 553.15 "Final temperature" ;
parameter Real C1(unit = "kJ/(kg.K)") = 1.1807 "Heat capacity of Diphyl A-30 at T1" ;
parameter Real C2(unit = "kJ/(kg.K)") = 1.5198 "Heat capacity at T2" ;
parameter Real m(unit = "kg/hr") = 4000 "Mass flow rate of Diphyl A-30" ;

//=======================================================
//Variable Section
Real Cm(unit = "kJ/(kg.K)") "Mean heat capacity" ;
Real H1(unit = "kJ/kg") "Heat added from equation" ;
Real H2(unit = "kW") "Heat added from mean heat capacity data" ;
Real Q(unit = "kW") "Heat added for given flow rate" ;
Real E "% error" ;

//=======================================================
//Equation Section
equation
H1 = (0.7511*(T2-T1)+1.465*10^(-3)*(T2^2-T1^2)/2) ;
Q = H1*m/3600 ;
Cm = (C1+C2)/2 ;
H2 = m/3600*Cm*(T2-T1) ;
E = (H2-H1)/H1*100;

end Ex5_6;
//=======================================================