//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.61 Page 321
//Title: Heat of dilution for ice

//=======================================================
model Ex5_61

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Mass of original acid" ;
parameter Real lambda(unit = "kJ/kg") = 333.7 "Latent heat of fusion at 273.15 K from Table 5.8" ;

//=======================================================
//Variable Section
Real H(unit = "kJ/kg") "Enthalpy of ice" ;
Real HE(unit = "kJ/kg") "Equivalent energy supplied to maintain temp. at 291.15 K" ;

//=======================================================
//Equation Section
equation
H = -lambda-(291.15-273.15)*4.1868 ;
HE = -642.77-H*312.63/100 ;

end Ex5_61;
//=======================================================
