//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.7 Page 208
//Title: Roasting of pyrites fines 

//=======================================================
model Ex5_7

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 298.15 "Combustion occurs at STP" ;
parameter Real T2(unit = "K") = 775.15 "Temperature of gases leaving roaster" ;

//=======================================================
//Variable Section
Real delta_a(unit = "kJ/(kmol K)") " Coefficient of heat capacity equation" ;
Real delta_b(unit = "kJ/(kmol K)") " Coefficient of heat capacity equation" ;
Real delta_c(unit = "kJ/(kmol K)") " Coefficient of heat capacity equation" ;
Real delta_d(unit = "kJ/(kmol K)") " Coefficient of heat capacity equation" ;
Real Q(unit = "kJ/kmol") "Heat content of 1 kmol of gas mixture" ;

//=======================================================
//Equation Section
equation
delta_a = 0.0709*24.7706+0.1055*26.0257+0.0045*22.0376+0.8191*29.5909 ;
delta_b = 0.0709*62.9481*10^(-3)+0.1055*11.7551*10^(-3)+0.0045*121.624*10^(-3)+0.8191*(-5.141)*10^(-3) ;
delta_c = 0.0709*(-44.2582*10^(-6))+0.1055*(-2.3426*10^(-6))+0.0045*(-91.8673*10^(-6))+0.8191*13.1829*10^(-6);
delta_d = 0.0709*11.122*10^(-9)+0.1055*(-0.5623)*10^(-9)+0.0045*24.3691*10^(-9)+0.8191*(-4.968)*10^(-9) ;
Q = delta_a*(T2-T1)+delta_b*(T2^2-T1^2)/2+delta_c*(T2^3-T1^3)/3+delta_d*(T2^4-T1^4)/4 ;

end Ex5_7;
//=======================================================