//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.16 Page 387
//Title: Induced draft cooling tower

//======================================================
package Ex6_16

//======================================================
model Ex6_16_a 
/* Make up water requirement */

//======================================================
//Parameter Section
parameter Real T1(unit = "K") = 318.15 "Inlet temperature of cooling water" ;
parameter Real T2(unit = "K") = 305.15 "Inlet temperature of cooling water" ;
parameter Real Q(unit = "kW") = 530 "Heat duty" ;
parameter Real xm(unit = "mg/L") = 500 "Mass fraction of DS in make-up water" ;
parameter Real xc(unit = "mg/L") = 2000 "Mass fraction of DS in circulating water" ;

//======================================================
//Variable Section
Real Tav(unit = "K") "Average cooling water temperature" ;
Real E(unit = "kg/s") "Evaporation rate" ;
Real mc(unit = "kg/s") "Circulation rate of cooling water" ;
Real W(unit = "kg/s") "Windage" ;
Real M(unit = "kg/s") "Make up water" ;
Real B(unit = "kg/s") "Blow down from cooling tower" ;

//======================================================
//Equation Section
equation
M = E+W+B ;
Tav = (T1+T2)/2 ;
E = Q/2410.5 ;                        //lambda = 2410.5 at 311.65 K from steam tables Appendix A IV.1
Q = mc*4.1868*(T1-T2) ;
W = 0.3/100*mc ;
//Dissolved solids balance
M*xm = (B+W)*xc ;

end Ex6_16_a ;
//======================================================

//======================================================
model Ex6_16_b 
/* T, Absolute humidity and % saturation */

//======================================================
//Parameter Section 
parameter Real ma(unit = "kg/s") = 48 "Mass flow rate of air" ;
parameter Real H1 = 0.0196 "Humidity of incoming air in kg H2O(g)/kg dry air" ;
parameter Real iws(unit = "kJ/kg") = 2546.2 "At 297.55 Appendix IV.1" ;
parameter Real DP(unit = "K") = 297.45 "Dew point temperature" ;
parameter Real DB(unit = "K") = 308.15 "Dry bulb temperature" ;

//======================================================
//Reference Section
extends Ex6_16_a ;

//======================================================
//Variable Section

Real i1(unit = "kJ/kg") "Enthalpy of incomimg air" ;
Real i2(unit = "kJ/kg") "Enthalpy of outgoing air" ;
Real CH1(unit = "kJ/kg") "Humid heat of air entering" ;
Real H2 "Humidity of outgoing air in kg H2O(g)/kg dry air" ;
Real Sat "Percentage saturation from Fig. 6.15" ;

//======================================================
//Equation Section
equation
Q = ma*(i2-i1) ;
//Moisture balance
E = ma*(H2-H1) ;
CH1 = 1.006+1.84*H1 ;
i1 = 1.006*(DP-273.15)+H1*iws+CH1*(DB-DP) ;
Sat = 68.5 ;                                      //Ref. Fig. 6.15

//Ref. Fig. 6.15
end Ex6_16_b ;
//======================================================

end Ex6_16;
//======================================================
