//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.24 Page 403
//Title: Triple effect evaporater

//======================================================
model Ex6_24

//======================================================
//Parameter Section
parameter Real FI(unit = "kg/hr") = 4300 "Feed rate to SPD-I" ;
parameter Real x1 = 600 "Beta carotene content of oil in mg/kg pf feed" ;
parameter Real rho_t(unit = "kg/L") = 0.71 "Density of thermic fluid" ;
parameter Real rho_o(unit = "kg/L") = 0.825 "Density of red palm oil" ;

//======================================================
//Variable Section
Real Bcrtn(unit = "kg/hr") "Beta carotene in feed" ;
Real FII(unit = "kg/hr") "Feed to SPD-II" ;
Real evap_I(unit = "kg/hr") "Evaporation of esters in SPD-I" ;
Real FIII(unit = "kg/hr") "Feed to SPD-III" ;
Real evap_II(unit = "kg/hr") "Evaporation of esters in SPD-II" ;
Real C3(unit = "kg/hr") "Final concentration from stream of SDP-III" ;
Real evap_III(unit = "kg/hr") "Evaporation of esters in SPD-III" ;
Real Q1(unit = "kW") "Heat requirement in SPD-I" ;
Real Q2(unit = "kW") "Heat requirement in SPD-II" ;
Real Q3(unit = "kW") "Heat requirement in SPD-III" ;
Real Q(unit = "kW") "Total heat requirement" ;
Real ml(unit = "kg/hr") "Thermic fluid mass flow rate" ;
Real ql(unit = "m^3/hr") "Volumetric flow rate of thermic fluid" ;
Real mCCW1(unit = "m^3/hr") "Mass flow rate of circulating cooling water in SPD-I" ;
Real mCCW2(unit = "kg/hr") "Mass flow rate of circulating cooling water in SPD-II" ;
Real del_TII(unit = "K") "Raise in temperature of CCW in SPD-II" ;
Real mCCW3(unit = "kg/hr") "Mass flow rate of circulating cooling water in SPD-III" ;
Real del_TIII(unit = "K") "Raise in temperature of CCW in SPD-III" ;
Real del_T(unit = "K") "Overall raise in temperature of CCW in SPD-III" ;
Real mCCW(unit = "kg/hr") "Required cooling water flow rate in extrernal coolers" ;

//======================================================
//Equation Section
equation
Bcrtn = x1*10^(-6)*FI ;
FII = Bcrtn/0.00645 ;
evap_I = FI-FII ;
FIII = Bcrtn/0.057 ;
evap_II = FII-FIII ;
C3 = Bcrtn/0.4 ;
evap_III = FIII-C3 ;
Q1 = (FI*2.56*(468.15-373.15)+3900*450)/3600 ;
Q2 = (FII*2.56*(463.15-468.15)+354.737*450)/3600 ;
Q3 = (FIII*2.56*(453.15-463.15)+38.813*450)/3600 ;
Q = Q1+Q2+Q3 ;
ml = Q*3600/2.95/(503.15-478.15) ;
ql = ml/rho_t/1000 ;
mCCW1 = 3900*450/8/4.1868/1000 ;
mCCW2 = mCCW1*0.9*1000 ;
del_TII = 159623/mCCW2/4.1868 ;
mCCW3 = mCCW1*1000-mCCW2 ;
del_TIII = 17466/mCCW2/4.1868 ;
del_T = (1755000+159632+17466)/(mCCW1*1000*4.1868) ;
mCCW = 1932098/8/4.1868 ;

end Ex6_24;
//======================================================