//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.3 Page 353
//Title: Azeotropic distillation

//======================================================
model Ex6_3

//======================================================
//Parameter Section
parameter Real F(unit = "kmol/hr") = 100 "Fresh feed" ;
parameter Real RR = 1.75 "Reflux ratio" ;

//======================================================
//Variable Section
Real D1(unit = "kmol/hr") "Bottoms from separater" ;
Real V2(unit = "kmol/hr") "Vapour from II distillation column" ;
Real n1(unit = "kmol/hr") "IPA in V2" ;
Real n2(unit = "kmol/hr") "H2O in V2" ;
Real W2(unit = "kmol/hr") "Bottom from II distillation column" ;
Real n3(unit = "kmol/hr") "IPA in W2" ;
Real n4(unit = "kmol/hr") "H2O in W2" ;
Real W3(unit = "kmol/hr") "Bottom from III distillation column" ;
Real n8(unit = "kmol/hr") "H2O in W3" ;
Real W1(unit = "kmol/hr") "Bottom from I distillation column" ;
Real n5(unit = "kmol/hr") "IPA in W3" ;
Real n6(unit = "kmol/hr") "IPA in D3" ;
Real D3(unit = "kmol/hr") "Distillate from III distillation column" ;
Real F1(unit = "kmol/hr") "Mixed feed" ; 
Real n7(unit = "kmol/hr") "H2O in D3" ;
Real R(unit = "kmol/hr") "Reflux" ;
Real V1(unit = "kmol/hr") "Vapour from I distillation column" ;
Real Rec "Recucle ratio in terms of D3/F" ;

//======================================================
//Equation Section
equation
//Cyclohexane balance
0.024*D1 = 0.488*V2 ;
n1 = 0.206*V2 ;
n2 = (1-0.488-0.206)*V2 ;
//W2 stream
n3 = 0.23*D1-0.206*V2 ;
n4 = (1-0.024-0.23)*D1-0.306*V2 ;
W2 = 4.471*V2+14.862*V2 ;
//W3 stream
n8 = (1-0.675)*F ;
//Overall material balance
W1+W3 = F ;
0.998*W1+0.001*W3 = 67.5 ;
n5 = W3*0.001 ;
n6 = 4.471*V2-n5 ;
D3 = n6/0.675 ;
F1 = F+D3 ;
n7 = 6.624*V2-0.047-(n6) ;
n8 = 14.862*V2-(2.153*V2-0.015) ;
RR = R/D1 ;
V1+V2-D1 = R ;
Rec = D3/F ;

end Ex6_3;
//======================================================
