//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.8 Page 362
//Title: Recovery of Acetic acid by Ethyl Acetate extraction

//======================================================
model Ex6_8

//======================================================
//Parameter Section
parameter Real F(unit = "kg/hr") = 1000 "Feed rate" ;
parameter Real frac = 0.89 "Distribution coefficient" ;

//======================================================
//Variable Section
Real A(unit = "kg/hr",start = 0) "Mass of glacial acetic acid from column C2 " ;
Real W(unit = "kg/hr") "Mass of waste water  from column C3" ;
Real R(unit = "kg/hr") "Bottoms from column C1" ;
Real R1(unit  = "kg/hr") "Bottoms from column D1" ;
Real D(unit = "kg/hr") "Distillate from column C3 " ;
Real M1(unit = "kg/hr") "Mixed feed to column C3" ;
Real E(unit = "kg/hr") "Overhead from column C1 " ;
Real E1(unit = "kg/hr") "Overhead  from D1 " ;
Real M11(unit = "kg/hr") "Reflux to column C2 " ;
Real S(unit = "kg/hr") "Recycle from column C3 " ;
Real AA_loss(unit = "kg/hr") "Acetic acid in waste water" ;
Real recovery "Acetic acid recovery" ;

//======================================================
//Equation Section
equation 
//Refer Fig. 6.11, pg 363
W/A = 15.77/5.87 ;                     //Lever rule //W/A = AF/FW    
//Overall material balance
F = A+W ;
//Material balance across C3
W/D = 19.31/1.81 ;
M1 = D+W ;
R1/M1 = 4.63/(4.63+6.57) ;
R = M1-R1 ;
//Material balance across C2
M11/A = 15.6/3.97 ;                    //M11/A = EA/M11E
E = M11+A ;
//Material balance for C1
F+S = E+R  ;
S = D+E1 ;
AA_loss = W*0.04/F/0.3*100 ;
recovery = 100 - AA_loss ;
 
end Ex6_8;
//======================================================