//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.1 Page 434
//Title: Godavari colliery proximate and ultimate analysis

//======================================================
package Ex7_1

//======================================================
model Ex7_1_a
/* Net H2 in coal */

//======================================================
//Parameter Section
parameter Real F(unit = "kg") = 100 "Mass of coal" ;
parameter Real m1(unit = "kg") = 18.04 "O2 in coal" ;
parameter Real m(unit = "kg") = 7 "Moisture in coal" ;

//======================================================
//Variable Section
Real O2(unit = "kmol") "Moles of O2 in coal" ;
Real H2(unit = "kmol") "Equivalent H2 to combine with O2" ;
Real net_H2(unit = "kg") "Net H2 in coal" ;

//======================================================
//Equation Section
equation
O2 = m1/32 ;
H2 = 2*O2 ;
net_H2 = 2.79-H2*2 ;

end Ex7_1_a ;
//======================================================

//======================================================
model Ex7_1_b
/* Combined water in coal */

//======================================================
//Reference Section
extends Ex7_1_a ;

//======================================================
//Variable Section
Real com_H2O(unit = "kg") "Combined H2O" ;
Real m2(unit = "kg") "Water produced by burning H2" ;

//======================================================
//Equation Section
equation
m2 = H2*18 ;
com_H2O = m2-m ;

end Ex7_1_b ;
//======================================================

//======================================================
model Ex7_1_c
/* GCV */

//======================================================
//Parameter Section
parameter Real C = 50.22 "Mass fraction of C in coal" ;
parameter Real H = 2.79 "Mass fraction of H2 in coal" ;
parameter Real O = 18.04 "Mass fraction of O2 in coal" ;
parameter Real S = 0.37 "Mass fraction of S in coal" ;

//======================================================
//Variable Section
Real GCV(unit = "kJ/kg") "GCV" ;

//======================================================
//Equation Section
equation
GCV = 33950*C/100+144200*(H-(O/8))/100+9400*S/100 ;        //Dulong's equation

end Ex7_1_c ;
//======================================================

//======================================================
model Ex7_1_d
/* NCV */

//======================================================
//Parameter Section
parameter Real H2(unit = "kmol") = 1.395 "H2 in coal" ;
parameter Real GCV(unit = "kJ/kg") = 23392 "Reported GCV on ash free basis" ;

//======================================================
//Variable Section
Real m1(unit = "kg") "Water  vapour in product stream" ;
Real Q(unit = "kJ/kg") "Total heat of vapourisation" ;
Real f "Correction factor" ;
Real GCV_rec(unit = "kJ/kg") "GCV of received coal" ;
Real NCV(unit = "kJ/kg") "NCV of fuel" ;

//======================================================
//Equation Section
equation
m1 = H2*18+7 ;
Q = 2442.5*m1/100 ;
f = 1-0.21-0.07 ;
GCV_rec = GCV*f ;
NCV = GCV_rec-Q ;

end Ex7_1_d ;
//======================================================

//======================================================
model Ex7_1_e
/* Carbon content */

//======================================================
//Variable Section
Real C(unit = "kg") "Total carbon" ;

//======================================================
//Equation Section
equation
//Calderwood Equation
//Total C = 5.888+0.00512*(B-40.5*S)+-0.0053*(80-100*(VM/FC))^1.55 ;
C = 5.88+0.00512*(7240.8-40.5*0.37)+0.0053*(80-56.52)^1.55 ;

end Ex7_1_e ;
//======================================================

//======================================================
model Ex7_1_f
/* Proximate analysis */

//======================================================
//Variable Section
Real Volatile(unit = "kg") "Volatile matter" ;
Real Fixed_c(unit = "kg") "Fixed carbon" ;

//======================================================
//Equation Section
equation
Volatile = 26 ;
Fixed_c = 46 ;

end Ex7_1_f ;
//======================================================

end Ex7_1;
//======================================================
