//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.13 Page 479
//Title: Open hearth steel furnace

//====================================================== 
model Ex7_13

//======================================================
//Parameter Section
parameter Real F(unit = "kmol") = 100 "Dry producer gas as basis" ;
parameter Real Ts(unit = "K") = 463 "Satutation temperature at 12.5 bar" ;
parameter Real Hss(unit = "kJ/kg") = 2784.1 "Enthalpy at saturation" ;
parameter Real lambda(unit = "kJ/kg") = 1977.4 "Latent heat of vapourisation at Ts"; 
parameter Real i(unit = "kJ/kg") = 3045.6 "Heat of superheated steam at 12.5 bar and 573.15 K" ;

//======================================================
//Variable Section
Real Q7(unit = "kJ/hr") "Heat lost in flue gas" ;
Real H4(unit = "kJ/kg") "Heat load on economiser" ;
Real H6(unit = "kJ/kg") "Heat load on superheater" ;
Real Q4(unit = "kJ/hr") "Heat load of economiser" ;
Real Q5(unit = "kJ/hr") "Heat load of boiler" ;
Real Q6(unit = "kJ/hr") "Heat load of superheater" ;
Real Q(unit = "kJ/hr") "Heat recovery" ;
Real Q81(unit = "kJ/hr") "Heat loss in flue gas" ;

//======================================================
//Equation Section
equation
//Solving by Alternate method on pg 483
//Using Table 7.38 and 7.39
Q7 = 6469.67*(833.15-298.15) ;
//Heat balance of boiler
//Heat output: Basis 1 kg of steam
//Refer Appendix IV
H4 = 675.47-272.03 ;
H6 = i-Hss ;
Q4 = H4*7100 ;
Q5 = (Hss-675.47)*7100 ;
Q6 = H6*7100 ;
Q = Q4+Q5+Q6 ;
Q81 = 177.57*29*1.123*(478.15-298.15)*(27650/2672) ;

end Ex7_13;
//======================================================