//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.5 Page 451
//Title: Coal burnt in excess air

//======================================================
package Ex7_5

//======================================================
model Ex7_5_a
/* Theoretical O2 requirement */

//======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Mass of coal as basis" ;

//======================================================
//Variable Section
Real n(unit = "kmol") "Stoichiometric O2 requirement" ;
Real theo_O2 "Theoretical O2 requirement per unit mass of coal" ;

//======================================================
//Equation Section
equation
n = 4.185+0.698+0.012-0.564 ;
theo_O2 = n*32/100 ;

end Ex7_5_a ;
//======================================================

//======================================================
model Ex7_5_b
/* Theoretical dry air requirement */

//======================================================
//Parameter Section
parameter Real O2(unit = "kmol") = 4.331 "Theoretical moles of O2 required" ;
 
//======================================================
//Variable Section
Real N2(unit = "kmol") "N2 entering with O2" ;
Real Theo_air(unit = "kg") "Theoretical dry air required for complete combustion per unit mass of coal" ;

//======================================================
//Equation Section
equation
N2 = (79/21)*O2 ;
Theo_air = (O2*32+N2*28)/100 ;

end Ex7_5_b ;
//======================================================

//======================================================
model Ex7_5_c
/* Wet and orsat analysis */

//======================================================
//Parameter Section
parameter Real m1(unit = "kmol") = 0.073 "N2 in coal" ;

//======================================================
//Reference Section
extends Ex7_5_b ;

//======================================================
//Variable Section
Real act_air "Actual air supply" ;
Real act_O2(unit = "kmol") "Actual O2 supply" ;
Real act_N2(unit = "kmol") "Actual N2 accompanying O2" ;
Real N2_pro(unit = "kmol") "N2 in flue gas" ;
Real moist(unit = "kmol") "Total moisture in flue gas" ;
Real CO2(unit = "kmol") "CO2 in flue gas" ;
Real SO2(unit = "kmol") "SO2 in flue gas" ;

//======================================================
//Equation Section
equation
//Refer Table 7.9
act_air = Theo_air*2 ;
act_O2 = O2*2 ;
act_N2 = (79/21)*act_O2 ;
N2_pro = act_N2+m1 ;
moist = 1.395+(7/18) ;
CO2 = 4.185 ;                    //Assuming entire coal gets combusted to CO2
SO2 = 0.012 ;                    //Entire S gets burnt to SO2

end Ex7_5_c ;
//======================================================

end Ex7_5;
//======================================================
