//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.6 Page 452
//Title: Ultimate analysis of RFO

//======================================================
package Ex7_6

//======================================================
model Ex7_6_a
/* Theoretical dry air requirement */

//======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Mass of RFO as basis" ;

//======================================================
//Variable Section
Real theo_O2(unit = "kmol") "Theoretical O2 required" ;
Real theo_N2(unit = "kmol") "Theoretical N2 required" ;
Real theo_air(unit = "kg") "Theoretical total dry air per unit mass of RFO" ;

//======================================================
//Equation Section
equation
theo_O2 = 7.367+2.350+0.069 ;
theo_N2 = (79/21)*theo_O2 ;
theo_air = (theo_O2*32+theo_N2*28)/100 ;

end Ex7_6_a ;
//======================================================

//======================================================
model Ex7_6_b
/* Actual dry air supplied */

//======================================================
//Reference  Section
extends Ex7_6_a ;

//======================================================
//Variable Section
Real act_air(unit = "kmol") "Actual air supply" ;
Real act_air1(unit = "kg") "Mass of actual air per unit mass of RFO" ;

//======================================================
//Equation Section
equation
act_air = theo_air*100/29*1.25 ;
act_air1 = act_air*29/100 ;
 
end Ex7_6_b ;
//======================================================

//======================================================
model Ex7_6_c
/* Orsat composition */

//======================================================
//Parameter Section

//======================================================
//Variable Section
Real CO2(unit = "kmol") "CO2 in flue gas" ;
Real O2(unit = "kmol") "O2 in flue gas" ;
Real N2(unit = "kmol") "N2 in flue gas" ;
Real SO2(unit = "kmol") "SO2 in flue gas" ;

//======================================================
//Equation Section
equation
CO2 = 7.367 ;
O2 = (21/100)*58.25 - 9.786 ;
N2 = (79/100)*58.25 ;
SO2 = 0.069 ;

end Ex7_6_c ;
//======================================================

//======================================================
model Ex7_6_d
/* Conc of SO2 */

//======================================================
//Variable Section
Real x1 "Mole fraction of SO2" ;
Real SO2(unit = "ppm") "ppm of SO2" ;
 
//======================================================
//Equation Section
equation
x1 = 0.07/(55.925+5.695) ;
SO2 = x1*10^6 ;
 
end Ex7_6_d ;
//======================================================

//======================================================
model Ex7_6_e
/* Conc of SO2 of gas discharged at 523 K */

//======================================================
//Variable Section
Real SO2 "Concentration of SO2 in mg/kg of RFO " ;
Real V(unit = "m^3") "Volume of wet flue gas at 523.15 K and 100.7 kPa pressure" ;
Real conc(unit = "mg/m^3") "Conc. of SO2" ;

//======================================================
//Equation Section
equation
SO2 = 4.48*10^6/(1696.14+102.51) ;
V = (55.925+5.695)*8.314*523.15/100.7 ;
conc = 4.48*10^6/V ;

end Ex7_6_e ;
//======================================================

//======================================================
model Ex7_6_f
/* Acid dew point */

//======================================================
//Variable Section
Real T(unit = "K") "Acid dew point" ;

//======================================================
//Equation Section
equation
//For given RFO analysis, C/H mole ratio is 1.57
//S content = 2.2 mass %
//From Fig. 7.3, for 25% excess air
T = 424.4 ;

end Ex7_6_f ;
//======================================================

end Ex7_6;
//======================================================
