//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.11 Page 22
//Title: Ion content in tablet
//===================================================
model Ex2_11

//===================================================
//Parameter Section
parameter Real m1(unit = "mg") = 800 "Mass of Ca3(PO4)2" ;
parameter Real m2(unit = "mg") = 200 "Mass of CaCO3" ;
parameter Real m3(unit = "mg") = 5 "Mass of CaF2" ;
parameter Real Ca = 40.078 "Atomic weight of Ca" ;
parameter Real F = 18.9984032 "Atomic weight of F" ;

//===================================================
//Variable Section
Real M1 "Molar mass of Ca3(PO4)2" ;
Real M2 "Molar mass of CaCO3" ;
Real M3 "Molar mass of CaF2" ;
Real C1(unit = "mg") "Ca ion in tablet" ;
Real C2(unit = "mg") "F ion content in tablet" ;

//===================================================
//Equation Section
equation
M1 = 3*Ca+2*(30.97762+4*15.9994) ;
M2 = Ca+12.0107+3*15.9994 ;
M3 = Ca+2*F ;
C1 = (3*Ca/M1*m1)+(Ca/M2*m2)+(Ca/M3*m3)  ;
C2 = 2*F/M3*m3 ;

end Ex2_11;
//===================================================