//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.12 Page 23
//Title: Composition of salicylic acid solution
//===================================================
package Ex2_12

//===================================================
model Ex2_12_a
/* Mass % */

//===================================================
//Parameter Section
parameter Real Basis(unit = "kg") = 100 "Basis for methanol" ;
parameter Real m1(unit = "kg") = 64 "Mass of salicylic acid" ;

//===================================================
//Variable Section
Real m(unit = "kg") "Mass of solution" ;
Real mp1 "Mass percent of salicylic acid" ;
Real mp2 "Mass percent of methanol" ;

//===================================================
//Equation Section
equation
m = Basis+m1 ;
mp1 = m1/m*100 ;
mp2 = 100-mp1 ;

end Ex2_12_a ;
//===================================================

//===================================================
model Ex2_12_b
/* Mole % */

//===================================================
//Parameter Section
parameter Real M1(unit = "kg/kmol") = 32 "Molar mass of methanol" ;
parameter Real M2(unit = "kg/kmol") = 138 "Molar mass of salicylic acid" ;

//===================================================
//Reference Section
extends Ex2_12_a ;

//===================================================
//Variable Section
Real n1(unit = "kmol") "Moles of methanol" ;
Real n2(unit = "kmol") "Moles of salicylic acid" ;
Real n(unit = "kmol") "Total moles" ;
Real N1 "Mole percent of methanol" ;
Real N2 "Mole percent of salicylic acid" ;

//===================================================
//Equation section
equation
n1 = Basis/M1 ;
n2 = m1/M2 ;
n = n1+n2 ;
N1 = n1/n*100 ;
N2 = 100-N1 ;

end Ex2_12_b ;
//===================================================

end Ex2_12;
//===================================================
