//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.13 Page 24
//Title: Composition of solution
//===================================================
model Ex2_13

//===================================================
//Parameter Section
parameter Real m1(unit = "g") = 100 "Basis for water" ;
parameter Real m2(unit = "g") = 13.7 "Mass of HCl" ;
parameter Real m3(unit = "g") = 8.67 "Mass of NaCl" ;
parameter Real M1(unit = "g/mol") = 18.0153 "Molar mass of water" ;
parameter Real M2(unit = "g/mol") = 36.4609 "Molar mass of HCl" ;
parameter Real M3(unit = "g/mol") = 58.4428 "Molar mass of NaCl" ;

//===================================================
//Variable Section
Real m(unit = "g") "Total mass" ;
Real mp1 "Mass percent of H2O" ;
Real mp2 "Mass percent of HCl" ;
Real mp3 "Mass percent of NaCl" ;
Real n1(unit = "mol") "Moles of H2O" ;
Real n2(unit = "mol") "Moles of HCl";
Real n3(unit = "mol") "Moles of NaCl" ;
Real n(unit = "mol") "Total moles" ;
Real N1 "Mole percent of H2O" ;
Real N2 "Mole percent of HCl" ;
Real N3 "Mole percent of NaCl" ;

//===================================================
//Equation Section
equation
m = m1+m2+m3 ;
mp1 = m1/m*100 ;
mp2 = m2/m*100 ;
mp3 = m3/m*100 ;
n1 = m1/M1 ;
n2 = m2/M2 ;
n3 = m3/M3 ;
n = n1+n2+n3 ;
N1 = n1/n*100 ;
N2 = n2/n*100 ;
N3 = 100-N1-N2 ;

end Ex2_13;
//===============================================


      
