//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.22 Page 39
//Title: Composition and average molar mass of air
//===============================================
model Ex2_22

//===============================================
//Parameter Section
parameter Real Tmole(unit = "kmol" ) = 100 "Total moles of air" ;
parameter Real n1(unit = "kmol" ) = 21 "Moles of Oxygen in 100 kmole of air" ;
parameter Real n2(unit = "kmol" ) = 78 "Moles of Nitrogen in 100 kmole of air" ;
parameter Real n3(unit = "kmol" ) = 1  "Moles of Argon in  100 kmole of air" ;

//===============================================
//Variable Section
Real m1(unit = "kg") "Mass of Oxygen" ;
Real m2(unit = "kg") "Mass of Nitrogen" ;
Real m3(unit = "kg") "Mass of Argon" ;
Real Ma(unit = "kg/kmol") "Average molar mass of air" ;

//===============================================
//Equation Section
equation 
m1 = n1*31.9988 ;
m2 = n2*28.0134 ;
m3 = n3*39.948 ;
Ma = (m1+m2+m3)/Tmole ;
//Assuming that air is majorly composed of N2,O2,Ar
//31.9988 is Molar mass of Oxygen
//28.0134 is Molar mass of Nitrogen
//39.948 is Molar mass of Argon

end Ex2_22;
//===============================================