//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.25 Page 42
//Title: Molar volume
//=======================================================
package Ex2_25

//====================================================
model Ex2_25_a

/*Using Ideal gas law*/
//====================================================
//parameter Section
parameter Real T(unit = "K") = 773.15 "Temperature of carburetted water gas" ;
parameter Real p(unit = "bar") = 4 "Absolute Pressure of carburetted water gas" ;
parameter Real R1(unit = "kPa*m3)/(kmol*K)") = 8.3145 "Gas constant " ;

//====================================================
//Variable Section
Real V(unit = "m3/kmol") "Molar volume of gas mixture" ;

//====================================================
//Equation Section
equation
(p*100)*V = R1*T ;//Ideal gas law 
//p is multiplied with 100 to convert bar to kPa 

end Ex2_25_a ;
//====================================================

//====================================================
model Ex2_25_b

//====================================================
//Parameter Section
parameter Real T(unit = "K") = 773.15 "Temperature of carburetted water gas" ;
parameter Real p(unit = "bar") = 4 "Absolute Pressure of carburetted water gas" ;
parameter Real y1 = 0.352 "Mole fraction of H2" ;
parameter Real y2 = 0.148 "Mole fraction of CH4" ;
parameter Real y3 = 0.128 "Mole fraction of Ethylene" ;
parameter Real y4 = 0.015 "Mole fraction of CO2" ;
parameter Real y5 = 0.339 "Mole fraction of CO" ;
parameter Real y6 = 0.018 "Mole fraction of N2" ;
parameter Real R(unit = "bar L/(mol K) ") = 0.083145 "Gas constant" ;

//====================================================
//Varaible Section
Real Tc1(unit = "K") "Critical temperature of H2" ;
Real Tc2(unit = "K") "Critical temperature of Methane" ;
Real Tc3(unit = "K") "Critical temperature of Ethylene" ;
Real Tc4(unit = "K") "Critical temperature of CO2" ;
Real Tc5(unit = "K") "Critical temperature of CO" ;
Real Tc6(unit = "K") "Critical temperature of N2" ;
Real Tc(unit = "K") "Critical temperature of gas" ;
Real Pc1(unit = "bar") "Critical pressure of H2" ;
Real Pc2(unit = "bar") "Critical pressure of CH4" ;
Real Pc3(unit = "bar") "Critical pressure of Ethylene" ;
Real Pc4(unit = "bar") "Critical pressure of CO2" ;
Real Pc5(unit = "bar") "Critical pressure of CO" ;
Real Pc6(unit = "bar") "Critical pressure of N2" ;
Real Pc(unit = "bar") "Critical pressure of gas" ;
Real a(unit = "L^2 bar/(mol)^2") "Vanderwaals constant" ;
Real b(unit = "L/mol") "Vanderwaals constant" ;
Real V1(unit = "L/mol",start = 15) "Molar Volume of gas" ;

//====================================================
//Equation section
equation
//Ref. Appendix III
//Kay's rule is used for finding critical pressure and temperature of components 
Tc1 = y1*32.2 ;
Tc2 = y2*190.56 ;
Tc3 = y3*282.34 ;
Tc4 = y4*132.91 ;
Tc5 = y5*304.1 ;
Tc6 = y6*126.09 ;
Tc = Tc1+Tc2+Tc3+Tc4+Tc5+Tc6 ;
Pc1 = y1*12.97 ;
Pc2 = y2*45.99 ;
Pc3 = y3*50.41 ;
Pc4 = y4*34.99 ;
Pc5 = y5*73.75 ;
Pc6 = y6*33.94 ;
Pc = Pc1+Pc2+Pc3+Pc4+Pc5+Pc6 ;
a = 27*R^2*Tc^2/64/Pc ;
b = R*Tc/8/Pc ;
(p+a/V1^2)*(V1-b) = R*T ;

end Ex2_25_b ;
//====================================================

end Ex2_25;
//====================================================
