//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.27 Page 44
//Title: Composition of vapour mixture
//=======================================================
model Ex2_27

//======================================================= 
//Parameter Section
parameter Real T(unit = "K") = 338.15 "Temperaure of mixture" ;
parameter Real p(unit = "bar") = 5.7 "Gauge pressure" ;
parameter Real y3 = 0.491 "Mole fraction of n-butane in ternary mixture" ;
parameter Real Pv(unit = "kPa") = 3.293 "Vapour pressure of furfural at 338.15" ;

//======================================================= 
//Variable Section
Real P(unit = "bar") "Total pressure" ;
Real pv(unit = "kPa") "Actual Vapour pressure of furfural" ;
Real y1 "Mole fraction of furfural in vapour mixture" ;
Real y2 "Mole fraction of 1-butene in vapour mixture" ;

//======================================================= 
//Equation Section
equation
P = p+1.01 ;
pv = Pv*0.7737 ;//Raoult's law
y1 = pv/P/100 ;//Dalton's law
y2 = 1-y1-y3 ;
//P is divided by 100 to concert bar to kPa 

end Ex2_27;
//======================================================= 