//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.1 Page 60
//Title: Blown down in Lancashire boiler
//=======================================================
model Ex3_1

//=======================================================
//Parameter Section
parameter Real feed(unit = "kg") = 1 "Basis of 1 kg of feed water" ;
parameter Real m1(unit = "mg") = 1200 "Mass of dissolved solids in feed water" ;
parameter Real m2(unit ="mg") = 3500 "Dissolved solids in blow down" ;

//=======================================================
//Variable Section
Real x(unit = "kg") "Amount of feed water to be blown down" ;
Real blowdown "Percentage blow-down" ;

//=======================================================
//Equation Section
equation
x*m2 = feed*m1 ;
blowdown = x/1*100 ;

end Ex3_1;
//=======================================================