//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.14 Page 73
//Title: Ion-Exclusion process
//=======================================================
package Ex3_14

//Refer Table 3.7:Areas under the curve, page 75

 //=======================================================
 model Ex3_14_a
 /* % recovery of glycerine */
 
 //=======================================================
 //Variable Section
 Real Rg "Percentage recovery of glycerine" ;

 //=======================================================
 //Equation Section
 equation
 Rg = (8124/9448)*100 ;

 end Ex3_14_a ;
 //=======================================================

 //=======================================================
 model Ex3_14_b
 /* Loss of glycerine based on mixed feed */
 
 //=======================================================
 //Variable Section
 Real Lg "Percentage loss of glycerine" ;
 Real Rog "Percentage recycle of glycerine" ;
 extends Ex3_14_a ;
 
 //=======================================================
 //Equation Section
 equation
 Lg = (16+83)/9448*100 ;
 Rog = 100-Rg-Lg ;
 
 end Ex3_14_b ;
 //=======================================================
 
 //=======================================================
 model Ex3_14_c
 /* Product contamination */
 
 //=======================================================
 //Variable Section
 Real Nr "Percentage NaCl recycled" ;
 Real Nc "NaCl in product as contaminant of total NaCl fed" ;
 Real Gp "Glycerine in product" ;
 Real Ts "Total solute" ;
 Real Np "Percentage of NaCl of total solute in product " ;
 extends Ex3_14_a ;
 
 //=======================================================
 //Equation Section
 equation
 Nr = 3436/8616*100 ;
 Nc = 238/8124 ;
 Gp = 12*Rg/100 ;
 Ts = Nc+Gp ;
 Np = Nc/Ts*100 ;
   
 end Ex3_14_c ;
 //=======================================================
 
//=======================================================


end Ex3_14;