//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.6 Page 63
//Title: Pressure swing adsorption
//=======================================================
model Ex3_6

//=======================================================
//Parameter Section
parameter Real feed(unit = "Nm3/hr") = 170 "Rate of feed stream" ;
parameter Real C1 = 79 "Volume percentage of Nitrogen in feed stream" ;
parameter Real C2 = 21 "Volume percentage of Oxygen in feed stream" ;
parameter Real P(unit = "Nm3/hr") = 50 "Rate of product stream" ;
parameter Real p = 99 "Volume percent of Nitrogen in  product stream" ;

//=======================================================
//Variable Section 
Real P1(unit = "Nm3/hr") "Nitrogen content in product stream" ;
Real P2(unit = "Nm3/hr") "Uxygen content in product stream" ;
Real V1 "Volume percent of Nitrogen in reject stream" ;
Real V2 "Volume percent of Oxygen in reject stream" ;
Real V(unit = "Nm3/hr") "Volume of reject stream" ;

//=======================================================
//Equation Section
equation
P1 = p/100*P ;
P2 = P-P1 ;
V = (feed*C1/100-P1)+(feed*C2/100-P2) ;
V1 = (feed*C1/100-P1)/V*100 ;
V2 = (feed*C2/100-P2)/V*100;

end Ex3_6;
//=======================================================