//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.7 Page 64
//Title: Oleum strength
//=======================================================
model Ex3_7

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Basis for SO3-free mixed acid" ;
parameter Real m1(unit = "kg") = 55 "Mass of HNO3 in feed" ;
parameter Real m2(unit = "kg") = 45 "Mass of H2SO4 in feed" ;

//=======================================================
//Variable Section
Real M(unit = "kg") "SO3 equivalent to 3 kg water" ;
Real Q(unit = "kg") "oleum to be mixed" ;
Real S "Strength of Oleum" ;
Real R "Ratio of HNO3/Oleum" ;

//=======================================================
//Equation Section
equation
M = (80/18)*3 ;
Q = m2+M;
S = M/Q*100 ;
R = m1/Q ;

end Ex3_7;
//=======================================================