//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.9 Page 65
//Title: Analysis of borewell water
//=======================================================
model Ex3_9

//=======================================================
//Parameter Section
parameter Real basis(unit = "l") = 1 "Basis for water" ;
parameter Real Cl(unit = "mg") = 475.6 "Chlorides as Cl in sample water" ;
parameter Real SO4(unit = "mg") = 102.9 "Sulphates as SO4 in water" ;
parameter Real eq1 = 50 "Equivalent mass of CaCO3" ;
parameter Real eq2 = 53 "Equivalent mass of Na2CO3" ;
parameter Real Bi(unit = "kg") = 390.6 "Total bicarbonates in water" ;
parameter Real tem(unit = "kg") = 384 "Temporary hardness" ;
parameter Real eq3 = 84 "Equivalent mass of NaHCO3" ;
parameter Real eq4 = 73.15 "Equivalent mass of Mg(HCO3)2" ;
parameter Real Mg(unit = "kg") = 225 "Magnesium hardness" ;
parameter Real eq5 = 81 "Equivalent mass of Ca(HCO3)2" ;
 
//=======================================================
//Variable Section
Real m1(unit = "mg") "NaCl present in water" ;
Real m2(unit = "mg") "Na2SO4 present in water" ;
Real m3(unit = "mg") "Na2CO3 present in water" ;
Real m4(unit = "mg") "NaHCO3 present in water " ;
Real m5(unit = "mg") "Mg(HCO3)2 present in water" ;
Real m6(unit = "mg") "Ca(HCO3)2 present in water" ;

//=======================================================
//Equation Section 
equation
//58.5 mg of NaCl is equivalent to 35.5 mg of Cl
m1 = (58.5/35.5)*Cl;
//142 mg of Na2SO4 is equivalent to 96 mg of SO4
m2 = (142/96)*SO4 ;
m3 = eq2/eq1*65.9 ;
m4 = (Bi-tem)*eq3/eq1 ;
m5 = eq4/eq1*Mg ;
m6 = eq5/eq1*159 ;

end Ex3_9;