//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.1 Page 116
//Title: Manufacture of MCA

//=======================================================
model Ex4_1

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg") = 5000 "Mass of MCA produced" ;
parameter Real m2(unit = "kg") = 4536 "Mass of Cl2 required" ;
parameter Real m3(unit = "kg") = 263 "Mass of DCA produced" ;

//=======================================================
//Variable Section
Real n1(unit = "kmol") "Moles of MCA produced" ;
Real n2(unit = "kmol") "Moles of Cl2 charged" ;
Real n3(unit = "kmol") "Moles of DCA produced" ;
Real n4(unit = "kmol") "Total moles of Cl2 utilised" ;
Real conversion "% Conversion of Cl2 " ;
Real yield "Yield % of MCA" ;
Real selectivity "Selectivity of MCA" ;

//=======================================================
//Equation Section
equation
n1 = m1/94.5 ;
n2 = m2/71 ;
n3 = m3/129 ;             //One mole of MCA produced consumes one mole of Cl2
n4 = n1+2*n3 ;            //One mole of DCA produced consumes two moles of Cl2
conversion = n4/n2*100 ;
yield = n1/n4*100 ;
selectivity = n1/(2*n3) ; 
//Basis of 1 day
//Note:Cl2 is taken as limiting component
end Ex4_1;
//=======================================================