//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.16 Page 144
//Title: Hooker-type diaphragm cell 

//=======================================================
package Ex4_16

//=======================================================
model Ex4_16_a
/*Current efficiency */

//=======================================================
//Parameter Section
parameter Real I(unit = "A") = 15000 "Current passing through cell" ;
parameter Real t(unit = "hr") = 24 "Time of operation of cell" ;
parameter Real m2(unit = "kg/day") = 514.1 "Production of NaOH" ;
 
//=======================================================
//Variable Section
Real E(unit = "faraday/day") "Total energy through cell" ;
Real m1(unit = "kg/day") "Theoretical NaOH formation" ;
Real I_eff "Current efficiency" ;

//=======================================================
//Equation Section
equation
E = I*t*3600/96485 ;
m1 = E*40/1000 ;
I_eff = m2/m1*100 ;

end Ex4_16_a ;
//=======================================================

//=======================================================
model Ex4_16_b
/* Cl2 and H2 produced */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg/day") = 514.1 "Production of NaOH" ;

//=======================================================
//Variable Section
Real m3(unit = "kg/d") "Chlorine produced" ;
Real m4(unit = "kg/d") "H2 produced" ;

//=======================================================
//Equation Section 
equation
m3 = (35.5/40)*m ;
m4 = (m3*2)/(35.5*2) ;

end Ex4_16_b ;
//=======================================================

//=======================================================
model Ex4_16_c
/* Evaporation loss */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg/day") = 514.1 "Production of NaOH" ;
parameter Real conc1 = 11 "Mass percent of NaOH in cell liquor" ;
parameter Real conc2 = 26.6 "Mass of NaCl in brine soln" ;

//=======================================================
//Variable Section
Real m1(unit = "kg/day") "NaCl consumed in cell" ;
Real m2(unit = "kg/day") "Total cell liquor" ;
Real m3(unit = "kg/day") "NaCl remained in cell" ;
Real m4(unit = "kg/day") "Total NaCl entering cell" ;
Real m5(unit = "kg/day") "Brine feed rate" ;
Real m6(unit = "kg/day") "Water consumed in reaction" ;
Real m7(unit = "kg/day") "Water loss due to evaporation" ;

//=======================================================
//Equation Section
equation
m1 =  58.5/40*m ;
m2 = m*100/conc1 ;
m3 = m*1.4 ;
m4 = m1+m3 ;
m5 = m4*100/conc2 ;
m6 = 18/40*m ;
m7 = m5-(m2+m6) ;

//Note: Salt/NaOH = 1.4:1 by mass in cell liquor

end Ex4_16_c ;
//=======================================================

end Ex4_16;
//=======================================================
