//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.17 Page 146

//Title: Ammonia production in fertiliser plant 

//=======================================================
package Ex4_17

//=======================================================
model Ex4_17_a 
/* Recyle rate and ratio */

//=======================================================
//Variable Section
Real Recycle_ratio "Recycle ratio" ;

//=======================================================
//Referance Section
extends Ex4_17_b ;

//=======================================================
//Equation Section
equation
Recycle_ratio = R/F ;          //in kmol of recycle gas per kmol of fresh feed

end Ex4_17_a ;
//=======================================================

//=======================================================
model Ex4_17_b
/* Purge gas rate */

//=======================================================
//Parameter Section
parameter Real F(unit = "kmol/s") = 100 "Freash feed rate" ;
parameter Real conv = 25 "% conversion"; 
parameter Real inert = 10 "Mole % of inert in mixed feed" ;
parameter Real G(unit = "kmol/s") = 65 "% ammonia separated from outlet gas";
parameter Real N2_f(unit = "kmol/s") = 24.75 "N2 in feed" ;

//=======================================================
//Variable Section
Real M(unit = "kmol/s",start = 400) "Mixed feed to converter" ;
Real R(unit = "kmol/s") "Recycle feed to converter" ;
Real a(unit = "kmol/s",start = 1) "N2 in mixed feed" ; 
Real H2_m(unit = "kmol/s") "H2 in mixed feed" ;
Real I_m(unit = "kmol/s",start = 1) "Inerts in mixed feed" ;
Real NH3_m(unit = "kmol/s") "Ammonia in mixed feed" ;
Real N2_c(unit = "kmol/s") "N2 reacted in converter gas" ;
Real H2_c(unit = "kmol/s") "H2 reacted in converter gas" ;
Real NH3_c(unit = "kmol/s") "NH3 produced in converter gas" ;
Real C(unit = "kmol/s") "Total gas leaving converter" ;
Real T(unit = "kmol/s",start = 1) "Total NH3 in outlet gas" ;
Real S(unit = "kmol/s") "NH3 separated in separator" ;
Real uncond(unit = "kmol/s") "NH3 uncondensed" ;
Real P(unit = "kmol/s") "Purge" ;
Real Inert_P(unit = "kmol/s") "Inerts in purge" ;
Real Total_s(unit = "kmol/s") "Total gas mixture leaving separater" ;
Real inert_f(unit = "kmol/s") "Inerts in feed" ; 
Real N2_p(unit = "kmol/s") "N2 in purge" ;

//=======================================================
//Equation Section
equation
//Mixed feed analysis
F+R = M ;
H2_m = 3*a ;
I_m = inert/100*M ;
NH3_m = M-a-H2_m-I_m ;
//Conveter gas analysis
N2_c = conv/100*a ;
H2_c = 3*N2_c ;                                     //N2+3H2=2NH3
NH3_c = 2*N2_c ;
C = M-N2_c-H2_c+NH3_c ;
T = NH3_m+NH3_c ;
S = T*G/100 ;
uncond = T*(100-G)/100 ;
Total_s = (a-N2_c)+(H2_m-H2_c)+uncond+I_m ;
Inert_P = I_m*P/Total_s ;
inert_f = F*1/100 ;
Inert_P = inert_f ;
F+Total_s-P = M ;
//N2 balance
N2_p = (a-N2_c)*P/Total_s ;
a-N2_c-N2_p+N2_f = a ;
                          
end Ex4_17_b ;
//=======================================================

//=======================================================
model Ex4_17_c
/* Product NH3 stream */

//=======================================================
//Referance Section
extends Ex4_17_b ;

//=======================================================
//Variable Section
Real m(unit = "kg/s") "Mass rate of NH3 in product stream" ;

//=======================================================
//Equation Section 
equation
m = S*17.0305 ;

//Note: Molar mass of NH3 17.0305 kg/kmol

end Ex4_17_c ;
//=======================================================

//=======================================================
model Ex4_17_d
/* Composition of streams */

//=======================================================
//Varaible Section
Real N2_R(unit = "kmol/s") "N2 in recycle stream" ;
Real H2_R(unit = "kmol/s") "H2 in recycle stream" ;
Real NH3_R(unit = "kmol/s") "NH3 in recycle stream" ;
Real I_R(unit = "kmol/s") "Inerts in  recycle stream";

//=======================================================
//Referance Section
extends Ex4_17_b ;

//=======================================================
//Equation Section
equation
N2_R = a-24.75 ;
H2_R = H2_m-74.25 ;
NH3_R = NH3_m-1 ;
I_R = I_m ;

end Ex4_17_d ;
//=======================================================

end Ex4_17;
// =======================================================
