//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.2 Page 117
//Title: Bechamp process

//=======================================================
package Ex4_2

//=======================================================
model Ex4_2_a
/* Yield of OT */

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg") = 700 "Mass of ONT added" ;
parameter Real p1 = 99 "Purity of OT produced" ;
parameter Real m3(unit = "kg") = 505 "Mass of OT produced" ;
parameter Real p2 = 98 "Percent of completion of reduction" ;

//=======================================================
//Variable Section
Real K1(unit = "kg") "Mass of OT pure OT" ;
Real K2(unit = "kg") "Mass of ONT required" ;
Real K3(unit = "kg") "Mass of ONT reacted" ;
Real yield "Yield % of OT" ;

//=======================================================
//Equation Section
equation
K1 = m3*p1/100 ;
K2 = (4*137*K1)/(4*107) ;  //4 moles of ONT produces 4 moles of OT
K3 = m1*p2/100 ;
yield = K2/K3*100 ;

//NOTE:Molar mass of ONT is 137
//Molar mass of OT is 107

end Ex4_2_a ;
//=======================================================

//=======================================================
model Ex4_2_b
/* Excess of iron */

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg") = 700 "Mass of ONT added" ;
parameter Real m2(unit = "kg") = 800 "Mass of iron turnings added" ;
parameter Real p1 = 90 "Percent Fe in iron turnings" ;

//=======================================================
//Variable Section
Real Theo(unit = "kg")  "Theoretical iron requirement" ;
Real Charged(unit = "kg") "Iron charged" ;
Real Excess "Percent of excess iron" ;

//=======================================================
//Equation Section
equation
Theo = 9*56*m1/4/137 ; //4 mol of ONT reacts with 9 mol of Fe
Charged = m2*p1/100 ;
Excess = (Charged - Theo)/Theo *100 ;

end Ex4_2_b ;
//=======================================================
end Ex4_2;
